package com.cybelia.sandra;

import com.cybelia.sandra.entities.ActionSecurite;
import com.cybelia.sandra.entities.ActionSecuriteDAO;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.CamionDAO;
import com.cybelia.sandra.entities.ChargementUsineConfig;
import com.cybelia.sandra.entities.ChargementUsineConfigDAO;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.ChauffeurDAO;
import com.cybelia.sandra.entities.Commande;
import com.cybelia.sandra.entities.CommandeDAO;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveurDAO;
import com.cybelia.sandra.entities.EleveursDoublons;
import com.cybelia.sandra.entities.EleveursDoublonsDAO;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.EtapeDAO;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoAccessDAO;
import com.cybelia.sandra.entities.InfoChargement;
import com.cybelia.sandra.entities.InfoChargementDAO;
import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.entities.LabelDAO;
import com.cybelia.sandra.entities.Lieu;
import com.cybelia.sandra.entities.LieuDAO;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.LigneProduitDAO;
import com.cybelia.sandra.entities.Note;
import com.cybelia.sandra.entities.NoteDAO;
import com.cybelia.sandra.entities.SecuriteGroupe;
import com.cybelia.sandra.entities.SecuriteGroupeDAO;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourDAO;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.entities.TransporteurDAO;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.UserIndicateursDAO;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.entities.UsineDAO;
import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.entities.notifier.CronDAO;
import com.cybelia.sandra.entities.notifier.Event;
import com.cybelia.sandra.entities.notifier.EventDAO;
import com.cybelia.sandra.entities.notifier.Queue;
import com.cybelia.sandra.entities.notifier.QueueDAO;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.PointGPSDAO;
import com.cybelia.sandra.entities.sig.TraceGPS;
import com.cybelia.sandra.entities.sig.TraceGPSDAO;
import com.cybelia.sandra.entities.synchro.Log;
import com.cybelia.sandra.entities.synchro.LogDAO;
import com.cybelia.sandra.entities.synchro.Synchro;
import com.cybelia.sandra.entities.synchro.SynchroDAO;
import com.cybelia.sandra.entities.trace.CREtape;
import com.cybelia.sandra.entities.trace.CREtapeDAO;
import com.cybelia.sandra.entities.trace.CRTour;
import com.cybelia.sandra.entities.trace.CRTourDAO;
import com.cybelia.sandra.entities.trace.CRUsine;
import com.cybelia.sandra.entities.trace.CRUsineDAO;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviEtapeDAO;
import com.cybelia.sandra.entities.trace.SuiviLigneProduit;
import com.cybelia.sandra.entities.trace.SuiviLigneProduitDAO;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviTourDAO;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import com.cybelia.sandra.entities.trace.SuiviUsineDAO;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserDAO;

public class SandraDAOHelper {

    public enum SandraEntityEnum implements TopiaEntityEnum {
        ActionSecurite(ActionSecurite.class),
        Camion(Camion.class),
        ChargementUsineConfig(ChargementUsineConfig.class),
        Chauffeur(Chauffeur.class),
        Commande(Commande.class),
        Eleveur(Eleveur.class),
        EleveursDoublons(EleveursDoublons.class),
        Etape(Etape.class),
        InfoAccess(InfoAccess.class),
        InfoChargement(InfoChargement.class),
        Label(Label.class),
        Lieu(Lieu.class),
        LigneProduit(LigneProduit.class),
        Note(Note.class),
        SecuriteGroupe(SecuriteGroupe.class),
        Societe(Societe.class),
        Tour(Tour.class),
        Transporteur(Transporteur.class),
        UserIndicateurs(UserIndicateurs.class),
        Usine(Usine.class),
        Cron(Cron.class),
        Event(Event.class),
        Queue(Queue.class),
        PointGPS(PointGPS.class),
        TraceGPS(TraceGPS.class),
        Log(Log.class),
        Synchro(Synchro.class),
        CREtape(CREtape.class),
        CRTour(CRTour.class),
        CRUsine(CRUsine.class),
        SuiviEtape(SuiviEtape.class),
        SuiviLigneProduit(SuiviLigneProduit.class),
        SuiviTour(SuiviTour.class),
        SuiviUsine(SuiviUsine.class),
        TaasUser(TaasUser.class);

        /**
         * The contract of the entity.
         */
        protected Class<? extends TopiaEntity> contract;

        /**
         * The fully qualified name of the implementation of the entity.
         */
        protected String implementationFQN;

        /**
         * The implementation class of the entity (will be lazy computed at runtime).
         */
        protected Class<? extends TopiaEntity> implementation;

        /**
         * The array of property involved in the natural key of the entity.
         */
        protected String[] naturalIds;

        SandraEntityEnum(Class<? extends TopiaEntity > contract, String... naturalIds)     {
        this.contract = contract;
        this.naturalIds = naturalIds;
        implementationFQN = contract.getName() + "Impl";
        }

        @Override
        public Class<? extends TopiaEntity> getContract()     {
        return contract;
        }

        @Override
        public String[] getNaturalIds()     {
        return naturalIds;
        }

        @Override
        public String getImplementationFQN()     {
        return implementationFQN;
        }

        @Override
        public void setImplementationFQN(String implementationFQN)     {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
        }

        @Override
        public boolean accept(Class<? extends TopiaEntity> klass)     {
        return SandraDAOHelper.getContractClass(klass) == contract;
        }

        @Override
        public Class<? extends TopiaEntity> getImplementation()     {
        if (implementation == null) {
        try {
                implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
            } catch (ClassNotFoundException e) {
                throw new TopiaRuntimeException("could not find class " + implementationFQN, e);
            }
        }
        return implementation;
        }

        public static SandraEntityEnum valueOf(TopiaEntity entity)     {
        return valueOf(entity.getClass());
        }

        public static SandraEntityEnum valueOf(Class<?> klass)     {
        if (klass.isInterface()) {
           return valueOf(klass.getSimpleName());
        }
        for (SandraEntityEnum entityEnum : SandraEntityEnum.values()) {
            if (entityEnum.getContract().isAssignableFrom(klass)) {
                //todo check it works for inheritance
                return entityEnum;
            }
        }
        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(SandraEntityEnum.values()));
        }

    } //SandraEntityEnum

    protected SandraDAOHelper() { }

    public static String getModelVersion() {
        return "1.4";
    }

    public static String getModelName() {
        return "Sandra";
    }

    public static ActionSecuriteDAO getActionSecuriteDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ActionSecuriteDAO result = ci.getDAO(ActionSecurite.class, ActionSecuriteDAO.class);
        return result;
    }

    public static CamionDAO getCamionDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CamionDAO result = ci.getDAO(Camion.class, CamionDAO.class);
        return result;
    }

    public static ChargementUsineConfigDAO getChargementUsineConfigDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ChargementUsineConfigDAO result = ci.getDAO(ChargementUsineConfig.class, ChargementUsineConfigDAO.class);
        return result;
    }

    public static ChauffeurDAO getChauffeurDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ChauffeurDAO result = ci.getDAO(Chauffeur.class, ChauffeurDAO.class);
        return result;
    }

    public static CommandeDAO getCommandeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CommandeDAO result = ci.getDAO(Commande.class, CommandeDAO.class);
        return result;
    }

    public static EleveurDAO getEleveurDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        EleveurDAO result = ci.getDAO(Eleveur.class, EleveurDAO.class);
        return result;
    }

    public static EleveursDoublonsDAO getEleveursDoublonsDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        EleveursDoublonsDAO result = ci.getDAO(EleveursDoublons.class, EleveursDoublonsDAO.class);
        return result;
    }

    public static EtapeDAO getEtapeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        EtapeDAO result = ci.getDAO(Etape.class, EtapeDAO.class);
        return result;
    }

    public static InfoAccessDAO getInfoAccessDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        InfoAccessDAO result = ci.getDAO(InfoAccess.class, InfoAccessDAO.class);
        return result;
    }

    public static InfoChargementDAO getInfoChargementDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        InfoChargementDAO result = ci.getDAO(InfoChargement.class, InfoChargementDAO.class);
        return result;
    }

    public static LabelDAO getLabelDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        LabelDAO result = ci.getDAO(Label.class, LabelDAO.class);
        return result;
    }

    public static LieuDAO getLieuDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        LieuDAO result = ci.getDAO(Lieu.class, LieuDAO.class);
        return result;
    }

    public static LigneProduitDAO getLigneProduitDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        LigneProduitDAO result = ci.getDAO(LigneProduit.class, LigneProduitDAO.class);
        return result;
    }

    public static NoteDAO getNoteDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        NoteDAO result = ci.getDAO(Note.class, NoteDAO.class);
        return result;
    }

    public static SecuriteGroupeDAO getSecuriteGroupeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SecuriteGroupeDAO result = ci.getDAO(SecuriteGroupe.class, SecuriteGroupeDAO.class);
        return result;
    }

    public static SocieteDAO getSocieteDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SocieteDAO result = ci.getDAO(Societe.class, SocieteDAO.class);
        return result;
    }

    public static TourDAO getTourDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TourDAO result = ci.getDAO(Tour.class, TourDAO.class);
        return result;
    }

    public static TransporteurDAO getTransporteurDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TransporteurDAO result = ci.getDAO(Transporteur.class, TransporteurDAO.class);
        return result;
    }

    public static UserIndicateursDAO getUserIndicateursDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        UserIndicateursDAO result = ci.getDAO(UserIndicateurs.class, UserIndicateursDAO.class);
        return result;
    }

    public static UsineDAO getUsineDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        UsineDAO result = ci.getDAO(Usine.class, UsineDAO.class);
        return result;
    }

    public static CronDAO getCronDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CronDAO result = ci.getDAO(Cron.class, CronDAO.class);
        return result;
    }

    public static EventDAO getEventDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        EventDAO result = ci.getDAO(Event.class, EventDAO.class);
        return result;
    }

    public static QueueDAO getQueueDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        QueueDAO result = ci.getDAO(Queue.class, QueueDAO.class);
        return result;
    }

    public static PointGPSDAO getPointGPSDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PointGPSDAO result = ci.getDAO(PointGPS.class, PointGPSDAO.class);
        return result;
    }

    public static TraceGPSDAO getTraceGPSDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TraceGPSDAO result = ci.getDAO(TraceGPS.class, TraceGPSDAO.class);
        return result;
    }

    public static LogDAO getLogDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        LogDAO result = ci.getDAO(Log.class, LogDAO.class);
        return result;
    }

    public static SynchroDAO getSynchroDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SynchroDAO result = ci.getDAO(Synchro.class, SynchroDAO.class);
        return result;
    }

    public static CREtapeDAO getCREtapeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CREtapeDAO result = ci.getDAO(CREtape.class, CREtapeDAO.class);
        return result;
    }

    public static CRTourDAO getCRTourDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CRTourDAO result = ci.getDAO(CRTour.class, CRTourDAO.class);
        return result;
    }

    public static CRUsineDAO getCRUsineDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CRUsineDAO result = ci.getDAO(CRUsine.class, CRUsineDAO.class);
        return result;
    }

    public static SuiviEtapeDAO getSuiviEtapeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SuiviEtapeDAO result = ci.getDAO(SuiviEtape.class, SuiviEtapeDAO.class);
        return result;
    }

    public static SuiviLigneProduitDAO getSuiviLigneProduitDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SuiviLigneProduitDAO result = ci.getDAO(SuiviLigneProduit.class, SuiviLigneProduitDAO.class);
        return result;
    }

    public static SuiviTourDAO getSuiviTourDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SuiviTourDAO result = ci.getDAO(SuiviTour.class, SuiviTourDAO.class);
        return result;
    }

    public static SuiviUsineDAO getSuiviUsineDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SuiviUsineDAO result = ci.getDAO(SuiviUsine.class, SuiviUsineDAO.class);
        return result;
    }

    public static TaasUserDAO getTaasUserDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TaasUserDAO result = ci.getDAO(TaasUser.class, TaasUserDAO.class);
        return result;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SandraEntityEnum constant = SandraEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SandraEntityEnum constant = SandraEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        SandraEntityEnum constant = SandraEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        SandraEntityEnum constant = SandraEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        SandraEntityEnum[] values = SandraEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        SandraEntityEnum[] values = SandraEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static SandraEntityEnum[] getContracts() {
        return SandraEntityEnum.values();
    }

} //SandraDAOHelper
