package fr.reseaumexico.model;

public abstract class Level extends AbstractMexicoBean {

    private static final long serialVersionUID = 3760615869365314359L;

    public static final String PROPERTY_VALUE = "value";

    public static final String PROPERTY_WEIGHT = "weight";

    protected String value;

    protected Integer weight;

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        String oldValue = getValue();
        this.value = value;
        firePropertyChange(PROPERTY_VALUE, oldValue, value);
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        Integer oldValue = getWeight();
        this.weight = weight;
        firePropertyChange(PROPERTY_WEIGHT, oldValue, weight);
    }

} //Level
