/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model.writer;

import fr.reseaumexico.model.InputDesign;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.writer.ExperimentDesignXmlWriter;
import fr.reseaumexico.model.writer.MexicoXmlWriter;
import fr.reseaumexico.model.writer.ScenarioXmlWriter;
import fr.reseaumexico.model.writer.XmlNode;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;

public class InputDesignXmlWriter
extends MexicoXmlWriter<InputDesign> {
    protected ExperimentDesignXmlWriter experimentDesignXmlWriter;

    public InputDesignXmlWriter(InputDesign model) throws IOException {
        super(model);
        this.experimentDesignXmlWriter = new ExperimentDesignXmlWriter(model.getExperimentDesign());
    }

    @Override
    public XmlNode getRootElement() {
        XmlNode rootXmlNode = new XmlNode(INPUT_DESIGN);
        this.composeInputDesignMeta(rootXmlNode);
        this.composeScenarios(rootXmlNode);
        return rootXmlNode;
    }

    protected void composeInputDesignMeta(XmlNode rootXmlNode) {
        Date date = ((InputDesign)((Object)this.model)).getDate();
        this.addParameter(rootXmlNode, "date", this.formatDate(date));
        rootXmlNode.add(this.experimentDesignXmlWriter.getRootElement());
    }

    protected void composeScenarios(XmlNode rootXmlNode) {
        Collection<Scenario> scenarios = ((InputDesign)((Object)this.model)).getScenario();
        if (scenarios != null) {
            for (Scenario scenario : scenarios) {
                ScenarioXmlWriter scenarioXmlWriter = new ScenarioXmlWriter(scenario, false);
                XmlNode scenariosXmlNode = scenarioXmlWriter.getRootElement();
                rootXmlNode.add(scenariosXmlNode);
            }
        }
    }
}

