/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model.parser;

import com.csvreader.CsvReader;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.io.Files;
import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.MexicoUtil;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.ScenarioImpl;
import fr.reseaumexico.model.ValueType;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class ScenarioCSVParser {
    protected final Map<String, Factor> factors;
    protected final Multimap<String, Factor> factorByName;
    protected final List<String> unknownFactors;

    public ScenarioCSVParser(Map<String, Factor> factors) {
        this.factors = factors;
        this.unknownFactors = new ArrayList<String>();
        this.factorByName = ArrayListMultimap.create();
        this.factorByName.putAll((Multimap)Multimaps.index(factors.values(), MexicoUtil.GET_FACTOR_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scenario getModel(File file) throws IOException {
        this.unknownFactors.clear();
        ScenarioImpl scenario = new ScenarioImpl();
        try (CsvReader csvReader = null;){
            csvReader = new CsvReader((Reader)Files.newReader((File)file, (Charset)Charsets.UTF_8), ',');
            LinkedHashMap factorValues = Maps.newLinkedHashMap();
            while (csvReader.readRecord()) {
                String factorName = csvReader.get(0);
                Factor factor = this.factors.get(factorName);
                if (factor == null) {
                    Collection possibleFactors = this.factorByName.get((Object)factorName);
                    if (CollectionUtils.isNotEmpty((Collection)possibleFactors)) {
                        factor = (Factor)((Object)possibleFactors.iterator().next());
                    } else {
                        this.unknownFactors.add(factorName);
                        continue;
                    }
                }
                ValueType valueType = factor.getDomain().getValueType();
                String value = csvReader.get(1);
                factorValues.put(factor, MexicoUtil.getTypedValue(valueType, value));
            }
            scenario.setFactorValues(factorValues);
        }
        return scenario;
    }

    public List<String> getUnknownFactors() {
        return Lists.newArrayList(this.unknownFactors);
    }
}

