package fr.reseaumexico.model;

import java.util.Date;

public abstract class Step extends AbstractMexicoBean {

    private static final long serialVersionUID = 3472668071107519332L;

    public static final String PROPERTY_DATE = "date";

    public static final String PROPERTY_INDEX = "index";

    public static final String PROPERTY_VALUE = "value";

    public static final String PROPERTY_VALUE_TYPE = "valueType";

    public static final String PROPERTY_FEATURE = "feature";

    protected Date date;

    protected int index;

    protected Object value;

    protected ValueType valueType;

    protected Feature feature;

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        Date oldValue = getDate();
        this.date = date;
        firePropertyChange(PROPERTY_DATE, oldValue, date);
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        int oldValue = getIndex();
        this.index = index;
        firePropertyChange(PROPERTY_INDEX, oldValue, index);
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        Object oldValue = getValue();
        this.value = value;
        firePropertyChange(PROPERTY_VALUE, oldValue, value);
    }

    public ValueType getValueType() {
        return valueType;
    }

    public void setValueType(ValueType valueType) {
        ValueType oldValue = getValueType();
        this.valueType = valueType;
        firePropertyChange(PROPERTY_VALUE_TYPE, oldValue, valueType);
    }

    public Feature getFeature() {
        return feature;
    }

    public void setFeature(Feature feature) {
        Feature oldValue = getFeature();
        this.feature = feature;
        firePropertyChange(PROPERTY_FEATURE, oldValue, feature);
    }

} //Step
