/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.editor.factorValue;

import fr.reseaumexico.editor.factorValue.FactorValueEditor;
import fr.reseaumexico.editor.factorValue.FactorValueEditorFactory;
import fr.reseaumexico.model.Factor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import jaxx.runtime.JAXXContext;

public class FactorValueCellEditor
extends AbstractCellEditor
implements TableCellEditor,
FocusListener {
    private static final long serialVersionUID = 1L;
    protected JTable table;
    protected Factor factor;
    protected Object currentValue;
    protected JTextField defaultInlineEditor = new JTextField();
    protected FactorValueEditorFactory.FactorValueCellEditor specificEditor;
    protected boolean isEditing;
    protected FactorValueEditorFactory factory;

    public FactorValueCellEditor(JAXXContext context) {
        this.defaultInlineEditor.addFocusListener(this);
        this.factory = (FactorValueEditorFactory)context.getContextValue(FactorValueEditorFactory.class);
        if (this.factory == null) {
            this.factory = new FactorValueEditorFactory();
        }
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isEditing) {
            this.currentValue = this.defaultInlineEditor.getText();
            this.isEditing = false;
        }
        if (this.specificEditor != null) {
            this.currentValue = this.specificEditor.getValue();
        }
        return this.currentValue;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.factor = (Factor)table.getValueAt(row, 0);
        this.currentValue = value;
        this.specificEditor = this.factory.getCellEditor(this.factor, this.currentValue);
        if (this.specificEditor != null) {
            Component component = this.specificEditor.getComponent();
            if (component instanceof JComboBox) {
                ((JComboBox)component).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FactorValueCellEditor.this.fireEditingStopped();
                    }
                });
            }
            component.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    FactorValueCellEditor.this.fireEditingStopped();
                }
            });
            return component;
        }
        this.defaultInlineEditor.setText(this.currentValue == null ? "" : String.valueOf(this.currentValue));
        return this.defaultInlineEditor;
    }

    @Override
    public void focusGained(FocusEvent e) {
        FactorValueEditor editor = this.factory.getDialogEditor(this.factor, this.currentValue);
        if (editor == null) {
            this.isEditing = true;
        } else {
            editor.setVisible(true);
            this.currentValue = editor.getValue();
            this.defaultInlineEditor.setText(this.currentValue == null ? "" : String.valueOf(this.currentValue));
            this.fireEditingStopped();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.fireEditingStopped();
    }
}

