/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.editor.demo;

import fr.reseaumexico.editor.demo.MexicoEditorDemoUI;
import fr.reseaumexico.model.InputDesign;
import fr.reseaumexico.model.event.InputDesignFactorEvent;
import fr.reseaumexico.model.event.InputDesignFactorListener;
import fr.reseaumexico.model.event.InputDesignScenarioEvent;
import fr.reseaumexico.model.event.InputDesignScenarioListener;
import fr.reseaumexico.model.parser.InputDesignParser;
import fr.reseaumexico.model.writer.InputDesignXmlWriter;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class MexicoEditorDemoUIHandler {
    private static Log log = LogFactory.getLog(MexicoEditorDemoUIHandler.class);

    public void closeApplication(MexicoEditorDemoUI ui) {
        ui.dispose();
    }

    public MexicoEditorDemoUI initUI(JAXXInitialContext context) {
        context.add((Object)this);
        MexicoEditorDemoUI ui = new MexicoEditorDemoUI((JAXXContext)context);
        ui.setVisible(true);
        ErrorDialogUI.init((Frame)ui);
        return ui;
    }

    public void openFile(final MexicoEditorDemoUI ui) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(I18n._((String)"jmexico.file.open.dialog", (Object[])new Object[0]));
        int returnVal = fileChooser.showOpenDialog(ui);
        if (returnVal == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            InputDesign inputDesign = this.readInputDesignFile(selectedFile);
            inputDesign.addInputDesignFactorListener(new InputDesignFactorListener(){

                public void factorValueChanged(InputDesignFactorEvent event) {
                    ui.setInputDesign(event.getSource());
                }
            });
            inputDesign.addInputDesignScenarioListener(new InputDesignScenarioListener(){

                public void scenarioAdded(InputDesignScenarioEvent event) {
                    ui.setInputDesign(event.getSource());
                }

                public void scenarioRemoved(InputDesignScenarioEvent event) {
                    ui.setInputDesign(event.getSource());
                }
            });
            ui.setInputDesign(inputDesign);
            ui.getModel().setInputDesignFile(selectedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(MexicoEditorDemoUI ui) {
        File selectedFile = ui.getModel().getInputDesignFile();
        try {
            InputDesignXmlWriter writer = new InputDesignXmlWriter(selectedFile, ui.getInputDesign());
            try {
                writer.write();
            }
            finally {
                writer.close();
                ui.getModel().setOptionChanged(false);
            }
        }
        catch (IOException eee) {
            log.error((Object)("Failed to save inputDesign file '" + selectedFile.getName() + "'"), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputDesign readInputDesignFile(File selectedFile) {
        InputDesign inputDesignModel = null;
        try {
            InputDesignParser inputDesignParser = new InputDesignParser(selectedFile);
            try {
                inputDesignModel = (InputDesign)inputDesignParser.getModel();
            }
            finally {
                inputDesignParser.close();
            }
        }
        catch (Exception eee) {
            log.error((Object)("Failed to read inputDesign file '" + selectedFile.getName() + "'"), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        return inputDesignModel;
    }
}

