package fr.reseaumexico.editor.demo;

/*
 * #%L
 * JMexico :: Swing Editor Demo
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2011 - 2013 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import fr.reseaumexico.editor.InputDesignEditor;
import fr.reseaumexico.model.InputDesign;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class MexicoEditorDemoUI extends JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MENU_FILE_SAVE_ENABLED = "menuFileSave.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVOW8TQRR+NvGZcCQhVoAghaNAFGskjiYRBBKsOLKJhBUpwg1j78Q70e7ssDubbBrET+AnQE+DREeFKKgpaBB/ASEKWsSb8bE+Nhex5JH1ju+d3/O7n5DyPbiyTcLQ8AIumUONtYebm+uNbdqUK9RvekxI14P2J5GEZB3GzZ7cl3CtXlHuxY57cdl1hMsp7/NeqEDel3s29S1KpYTLgx5N3y/WeuqFUAReF7WXVBzqm9+/kq/NV2+TAKHA7PJYyvxhXlElYxVIMlPCFEbaIUWb8Bam4THewnxPK9myTXz/CXHoC3gJmQqkBfEQTMLVo5esMbR/KCTkHMJ4yUNICcaWZ3jUpyRwaMiarkFNhp6GSR3XqGrRYy1ZQcFGWQgNk5aQsQg3bepJuHs8iNW2X4SUclyT2hJuHw+nqrwilDGH8kDCedWy0PB3sYPGWhVlj0hfrKyyKjEbK58csVQ2Uz3Tia7pusCmwsyIeVlSR9nOjLrUyI4e18Uh/fW1GsXxESziloTCAGRPM+gzhoXLGKxJxkWgZs1avN0WCTf26WB52FRh5ARu6qWBTUUOGBEHoiVN1CHlBSiWMFsfpc1TVLUJMztEGAWotX8L098+/vhQ6rIki7FnYk37SI7bKzxX4I4xFfpsmyKBZHaxSsRCHXI+tfFC6AswF5NYraPG5DCeHrih3I1V4lsIkcp8//S58PzrKUiWIG+7xCwRZV+GnLSwkZZrm6F4sKQzmtjN4nsOv0mciqShVDvUabQavLGl9yrrcNxPzpoSEqUQmzIX05ReZo3clz/TtfdL3cYkMNEL+5pHzUk9gzTjNuNUH5DObYg9GOPCp4HpRjcg7ipAHzdEhy839WscUH9hpH7D1Wzpb8J6qJl1R1enft2DIXadKKCPXBsMWDswoOLmYQET+0xYcTEOXJP0CKBpi7KWhbBTi+3hzROJx74RSHp/BDeh3vxRUG2y5waIembRJJLMNxg38aScADG1i/9JllJv/D9IhnLSsKnezXo8zBzC/AMNb2ER/wcAAA==";
    private static final Log log = LogFactory.getLog(MexicoEditorDemoUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenuItem exit;
    protected MexicoEditorDemoUIHandler handler;
    protected InputDesignEditor inputDesignEditor;
    protected MexicoEditorDemoUI mainFrame = this;
    protected JMenuBar menu;
    protected JMenu menuFile;
    protected JMenuItem menuFileOpen;
    protected JMenuItem menuFileSave;
    protected MexicoEditorDemoUIModel model;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() {
        getHandler().initUI();
    }
    
    public void setInputDesign(InputDesign inputDesign) {
        getModel().setInputDesign(inputDesign);
        inputDesignEditor.setInputDesign(inputDesign);
    }
    
    public InputDesign getInputDesign() {
        return getModel().getInputDesign();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MexicoEditorDemoUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public MexicoEditorDemoUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MexicoEditorDemoUI() {
        $initialize();
    }

    public MexicoEditorDemoUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MexicoEditorDemoUI(String param0) {
        super(param0);
        $initialize();
    }

    public MexicoEditorDemoUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MexicoEditorDemoUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MexicoEditorDemoUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__exit(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().closeApplication();
    }

    public void doActionPerformed__on__menuFileOpen(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().openFile();
    }

    public void doActionPerformed__on__menuFileSave(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().saveFile();
    }

    public void doWindowClosing__on__mainFrame(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().closeApplication();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JMenuItem getExit() {
        return exit;
    }

    public MexicoEditorDemoUIHandler getHandler() {
        return handler;
    }

    public InputDesignEditor getInputDesignEditor() {
        return inputDesignEditor;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileOpen() {
        return menuFileOpen;
    }

    public JMenuItem getMenuFileSave() {
        return menuFileSave;
    }

    public MexicoEditorDemoUIModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(inputDesignEditor, BorderLayout.CENTER);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileOpen);
        menuFile.add(menuFileSave);
        menuFile.add($JSeparator0);
        menuFile.add(exit);
    }

    protected void createExit() {
        $objectMap.put("exit", exit = new JMenuItem());
        
        exit.setName("exit");
        exit.setText(_("jmexico.menu.exit"));
        exit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__exit"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new MexicoEditorDemoUIHandler(this));
    }

    protected void createInputDesignEditor() {
        $objectMap.put("inputDesignEditor", inputDesignEditor = new InputDesignEditor(this));
        
        inputDesignEditor.setName("inputDesignEditor");
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(_("jmexico.menu.file"));
        menuFile.setMnemonic(70);
    }

    protected void createMenuFileOpen() {
        $objectMap.put("menuFileOpen", menuFileOpen = new JMenuItem());
        
        menuFileOpen.setName("menuFileOpen");
        menuFileOpen.setText(_("jmexico.menu.file.open"));
        menuFileOpen.setMnemonic(79);
        menuFileOpen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileOpen"));
    }

    protected void createMenuFileSave() {
        $objectMap.put("menuFileSave", menuFileSave = new JMenuItem());
        
        menuFileSave.setName("menuFileSave");
        menuFileSave.setText(_("jmexico.menu.file.save"));
        menuFileSave.setMnemonic(83);
        menuFileSave.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileSave"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new MexicoEditorDemoUIModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("mainFrame", mainFrame);
        createHandler();
        createModel();
        createMenu();
        createMenuFile();
        createMenuFileOpen();
        createMenuFileSave();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createExit();
        createInputDesignEditor();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,800);
        mainFrame.getContentPane().setLayout(new BorderLayout());
        SwingUtil.setComponentWidth(mainFrame,800);
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_SAVE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("optionChanged", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    menuFileSave.setEnabled(getModel().isOptionChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("optionChanged", this);
                }
            }
        });
    }

}