package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.TerritoryType;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.user.bean.UserFormBean;
import org.apache.log4j.Logger;

/**
 * This action handles the user edition.
 * It allows the end user to edit user props.
 *
 * @author CS
 */
public class UpdateUserAction extends AbstractUserAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(AbstractUserAction.class);

    @Override
    protected String doExecute() {

        String nextPage;

        try {

            if (logger.isDebugEnabled()) {
                logger.debug(getText("fr.onema.sispea.struts.user.action.UpdateUserAction.debug.doExecute"));
            }

            // auth user
            UserDto lSessionUser = getCurrentUser();
            if (lSessionUser == null) {
                throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
            }

            // user to update
            // check for parameters : if no login parameter -> current user
            if ((user == null) || (user.getLogin() == null) || (user.getLogin().length() == 0)) {
                throw new SispeaException("fr.onema.sispea.struts.user.action.UserAction.errors.noUser");
            }

            // don't set the menu : let it as before

            // check form id
            if ((user.getForm() != user.getTerritoryFormId())
                && (user.getForm() != user.getUserFormId())
                && (user.getForm() != user.getCreationFormId())
                && (user.getForm() != user.getDateFormId())
                && (user.getForm() != user.getIdsFormId())) {
                throw new SispeaException("fr.onema.sispea.struts.user.action.UserAction.errors.unknownForm");
            }

            // update user
            boolean creating = false;
            if (user.getForm() == user.getCreationFormId()) {
                creating = true;
            }

            boolean editingPrivileges = false;
            if (user.getForm() == user.getDateFormId()) {
                editingPrivileges = true;
            }

            // validate user
            user = validateUser(user, creating);

            // check if current user is editing its own profile
            // current user editing somebody else profile -> right check
            if ((!editingProfile()) && (!checkUserRight(Right.EditUser, user.getTerritory(), exerciseService.getCurrentExercise()))) {
                throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
            }
            // else : current user editing its own profile -> no right check

            // Update lastUpdateDate information with current time
            updateLastUpdateDateWithCurrentTime();

            // update
            UserDto updatedUser = userService.updateUser(user, creating, user.loginChanged(), user.eMailChanged(), getLocale().getLanguage(), lSessionUser, false, editingPrivileges);
            user = new UserFormBean(updatedUser);

            // update user territory
            //user.setTerritory(userService.updateUserTerritory(user.getLogin(), user.getTerritory(), CurrentUserTerritory()));

            // reload user
            user = new UserFormBean(userService.readUser(user.getLogin()));

            // if profile -> reset user in session
            if (editingProfile()) {
                // set user in session
                if (getSispeaSession() != null) {
                    getSispeaSession().setUser(user);
                }
            }

            // message
            if (creating) {
                addActionMessage(getText("fr.onema.sispea.struts.user.action.UpdateUserAction.message.create"));
            } else {
                addActionMessage(getText("fr.onema.sispea.struts.user.action.UpdateUserAction.message.update"));
            }

            // creation message ?
            if ((creating)
                && (user.getTerritory() == null)
                && (user.getType() == null || user.getType().getTerritoryTypeExpected() != TerritoryType.Unknown)) {
                addActionError(getText("fr.onema.sispea.struts.user.action.UpdateUserAction.message.territoryChoose"));
            }

            // result
            nextPage = Action.SUCCESS;
        } catch (Exception e) {

            // ALWAYS log the errors
            logger.error("Error updating user '" + user.getLogin() + "'", e);
            addActionError(getText(e.getMessage()));
            nextPage = Action.INPUT;
        }

        // test if user if corrupted
        checkUserCorruption();

        return nextPage;
    }
}
