package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the users list visualization.
 * It allows the end user to view users lists.
 *
 * @author CS
 */
public class ShowUsersAction extends AbstractUsersAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(AbstractUsersAction.class);

    @Override
    protected String doExecute() throws Exception {

        // init action result
        String nextPage = Action.SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug(getText("fr.onema.sispea.struts.user.action.ShowUsersAction.debug.doExecute"));
        }

        // set the menu
        openMenu(MenuConstants.MENU_KEY_MYUSERS);

        // check if current user has right
        checkUserAccesRight();

        // use session ?
        if (searchUsersInfo == null || !searchUsersInfo.isUseSession()) {
            // get session parameters
            getSispeaSession().setUsersSearchInfo(searchUsersInfo);
        } else {
            // should use session
            // change some params ?
            if (searchUsersInfo.isChangeSortOrder()) {
                // update session order params with request params
                getSispeaSession().getUsersSearchInfo().getFilter().setSortCriterionId(searchUsersInfo.getFilter().getSortCriterionId());
                getSispeaSession().getUsersSearchInfo().getFilter().setSortDirectionId(searchUsersInfo.getFilter().getSortDirectionId());
            }
            if (searchUsersInfo.isChangeGoToPage()) {
                getSispeaSession().getUsersSearchInfo().getPaging().setGoToPage(searchUsersInfo.getPaging().getGoToPage());
            }
        }

        // get form
        if (getSispeaSession().getUsersSearchInfo() == null) {
            nextPage = "search";
        } else {

            // get form from session
            searchUsersInfo = getSispeaSession().getUsersSearchInfo();

            // display
            try {
                showUsers(false);

                // Load the mandates for the displayed users
                if (users != null) {
                    for (UserDto user : users) {

                        // Load the mandators and the user's mandates
                        user.setMandatedUsers(userService.readMandatesWhereMandated(user, false, false, -1, -1, null, null));
                        user.setMandators(userService.readMandatesWhereMandator(user, false, false, -1, -1, null, null));
                    }
                }
            } catch (SispeaException lEx) {
                // change result
                nextPage = Action.INPUT;
                addActionError(lEx.getMessage());
            }
        }

        // result
        return nextPage;
    }

}
