package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the user'selections visualization.
 * It allows the end user to view its saved selections.
 *
 * @author CS
 */
public class ShowUserSelectionsAction extends AbstractUserSelectionsAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowUserSelectionsAction.class);

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("show user's selections");
        }

        // init result
        String lResult = Action.SUCCESS;

        // open menu
        openMenu(MenuConstants.MENU_KEY_MYSELECTION);

        try {

            manageShowSelections();

        } catch (SispeaException lEx) {
            String lMessage = getText("fr.onema.sispea.jsp.user.showUserSelections.newSelect");
            logger.error(lMessage);
            addActionError(lMessage);
            lResult = Action.INPUT;
        }

        return lResult;
    }

}
