package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the users search form.
 * It allows the end user to search for users.
 *
 * @author CS
 */
public class SearchUsersAction extends AbstractUsersAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(SearchUsersAction.class);

    @Override
    protected String doExecute() throws Exception {

        // init action result
        String lResult = Action.SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("search users");
        }

        // set the menu
        openMenu(MenuConstants.MENU_KEY_MYUSERS);

        try {

            // check if current user has right
            checkUserAccesRight();

            // check if session user filter
            if (getSispeaSession().getUsersSearchInfo() != null) {
                setSearchUsersInfo(getSispeaSession().getUsersSearchInfo());
            }

        } catch (SispeaException lEx) {
            // change result
            lResult = Action.INPUT;
            addActionError(lEx.getMessage());
        }

        // result
        return lResult;
    }

}
