package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.struts.search.bean.BackType;
import org.apache.log4j.Logger;

/**
 * This action handles the user selections fill.
 * It allows the end user to fill its selections.
 *
 * @author CS
 */
public class FillUserSelectionsAction extends AbstractUserSelectionsAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(FillUserSelectionsAction.class);

    /**
     * The page name to go back to
     */
    protected Integer backPage;

    /**
     * Selected territory Id (last one if there are several)
     */
    protected Integer selectionId;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("fill user's selections");
        }

        // init result
        String lResult = Action.SUCCESS;

        // open menu
        openMenu(MenuConstants.MENU_KEY_MYSELECTION);

        // get the current user
        UserDto lUser = getCurrentUser();

        try {
            // check submit value
            if (submitValue == null) {
                throw new SispeaException("fr.onema.sispea.jsp.user.updateUserSelections.unknownAction");
            }

            // check territory ids selected
            if (territoryIdsSave == null || territoryIdsSave.size() == 0) {
                throw new SispeaException("fr.onema.sispea.jsp.user.updateUserSelections.missingId");
            }

            // loop on ids to add territories
            for (String lStrTerritoryId : territoryIdsSave) {
                // transform to integer
                Integer lTerritoryId;
                try {
                    lTerritoryId = Integer.valueOf(lStrTerritoryId);
                } catch (NumberFormatException lEx) {
                    throw new SispeaException("fr.onema.sispea.jsp.user.updateUserSelections.wrongFormatId");
                }

                // load ?
                TerritoryDto lTerritory = null;
                if (lTerritoryId != null) {
                    lTerritory = territoryService.readTerritory(lTerritoryId);
                }

                // loaded ?
                if (lTerritory == null) {
                    throw new SispeaException("fr.onema.sispea.jsp.user.updateUserSelections.unknownId=L'identifiant du territoire à ajouter est inconnu.");
                }

                // check user
                if (lUser == null) {

                    // user is not authenticated
                    if (getText("fr.onema.sispea.jsp.user.showUserSelections.delete").equals(submitValue)) {
                        // delete
                        getSispeaSession().getSelectedTerritories().remove(lTerritory);
                    } else {
                        // add to selection
                        getSispeaSession().getSelectedTerritories().add(lTerritory);
                    }

                } else {
                    // the user is authenticated
                    if (getText("fr.onema.sispea.jsp.user.showUserSelections.delete").equals(submitValue)) {
                        // delete
                        referentialService.removeToUserSelection(lUser, lTerritory);
                    } else {
                        // add territory to user selection
                        referentialService.addToUserSelection(lUser, lTerritory);
                    }
                }
                selectionId = lTerritoryId;
            }

        } catch (SispeaException lEx) {
            String lMessage = getText(lEx.getMessage());
            logger.error(lMessage);
            addActionError(lMessage);
            lResult = Action.INPUT;
        }

        return lResult;
    }

    public Integer getBackPage() {
        return backPage;
    }

    public void setBackPage(Integer pBackPage) {
        backPage = pBackPage;
    }

    public String getRedirectUrl() {
        return BackType.parse(backPage).getUrl();
    }

    public Integer getSelectionId() {
        return selectionId;
    }

    public void setSelectionId(Integer pSelectionId) {
        selectionId = pSelectionId;
    }

}
