package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import org.apache.log4j.Logger;


/**
 * This action handles the user deletion.
 * It allows the end user to delete user props.
 *
 * @author CS
 */
public class DeleteUserAction extends AbstractUserAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(DeleteUserAction.class);

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("delete user action - do execute");
        }

        //init
        String lResult = Action.SUCCESS;

        try {
            // parameters
            if ((user == null) || (user.getLogin() == null) || (user.getLogin().length() == 0)) {
                throw new SispeaException("fr.onema.sispea.struts.user.action.UserAction.errors.noUser");
            }

            // login à supprimer
            String lLogin = user.getLogin();

            // supprimer
            userService.deleteUser(getCurrentUser(), lLogin, getLocale().getLanguage());

            // message de succes
            addActionMessage(getText("fr.onema.sispea.struts.user.action.DeleteUserAction.message.success", "", lLogin));

        } catch (SispeaException lEx) {
            lResult = Action.INPUT;
            addActionError(getText("fr.onema.sispea.struts.user.action.DeleteUserAction.errors.msg") + getText(lEx.getMessage()));
        }

        // result
        return lResult;

    }

}
