package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.common.PagingDto;
import fr.onema.sispea.service.referential.OrganismDto;
import fr.onema.sispea.service.referential.OrganismType;
import fr.onema.sispea.service.referential.ReferentialService;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.struts.AbstractSispeaAction;
import fr.onema.sispea.struts.user.bean.SelectionComparator;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * This action handles the user'selections.
 * It allows the end user to view its saved selections.
 *
 * @author CS
 */
public abstract class AbstractUserSelectionsAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(AbstractUserSelectionsAction.class);

    @Autowired
    protected transient ReferentialService referentialService;

    /**
     * members to manage paging and sorting of single selections
     */
    protected PagingDto pagingSingleSelection = new PagingDto();

    /**
     * members to manage paging and sorting of multiple selections
     */
    protected PagingDto pagingMultipleSelection = new PagingDto();

    /**
     * the territories selected
     */
    protected List<TerritoryDto> territoriesSelection;

    /**
     * the single selections collection
     */
    protected List<TerritoryDto> singleSelections = new ArrayList<>();

    /**
     * the single selections collection
     */
    protected List<TerritoryDto> multipleSelections = new ArrayList<>();

    /**
     * the territory ids selected to add
     */
    protected List<String> territoryIdsSave;

    /**
     * the territory id selected to remove
     */
    protected String territoryIdSave;

    protected int singleSelectionSortCriterion = 1;

    protected Integer singleSelectionSortCriterionSelected;

    protected int singleSelectionSortDirection;

    protected Integer singleSelectionSortDirectionSelected;

    protected int multipleSelectionSortCriterion = 1;

    protected Integer multipleSelectionSortCriterionSelected;

    protected int multipleSelectionSortDirection;

    protected Integer multipleSelectionSortDirectionSelected;

//    @Override
//    protected String doExecute() throws Exception {
//
//        if (logger.isDebugEnabled()) {
//            logger.debug("User's selections - sould'nt be called");
//        }
//
//        return Action.SUCCESS;
//    }

    /**
     * called from Show and Update actions
     */
    protected void manageShowSelections() throws SispeaException {

        try {
            if (getCurrentUser() == null) {
                // the user is not authenticated
                // just display session selected territories
                territoriesSelection = getSispeaSession().getSelectedTerritories();

                manageSingleSelections();

            } else {
                // the user is authenticated
                // read territories
                territoriesSelection = referentialService.readUserSelections(getCurrentUser());

                manageSingleSelections();
                // authenticated user is allowed to use multiple selections
                manageMultipleSelections();
            }
        } catch (Exception e) {
            throw new SispeaException(e);
        }

    }

    /**
     * in charge of sorting and paging single selections list
     */
    protected void manageSingleSelections() {

        // create the single selections list from the complete list
        for (TerritoryDto t : territoriesSelection) {
            if (t.getCreator() == null) {
                singleSelections.add(t);
            }
        }

        int lCount = singleSelections.size();

        // set member result count
        pagingSingleSelection.setResultCount(lCount);

        if (lCount > 0) {

            // sorting
            if (singleSelectionSortCriterionSelected != null) {
                singleSelectionSortCriterion = singleSelectionSortCriterionSelected;
                singleSelectionSortDirection = singleSelectionSortDirectionSelected;
            }
            Collections.sort(singleSelections, new SelectionComparator(1, singleSelectionSortCriterion, singleSelectionSortDirection));

            // get start and end idx to extract
            Integer lStartIdx = pagingSingleSelection.getStartIndex() * pagingSingleSelection.getPageSize();
            Integer lEndIdx = lStartIdx + pagingSingleSelection.getPageSize();
            if (lEndIdx >= lCount) {
                lEndIdx = lCount;
            }

            // make sub list
            List<TerritoryDto> lSubList = singleSelections.subList(lStartIdx, lEndIdx);

            // set sub list
            singleSelections = lSubList;

            // set page offset
            pagingSingleSelection.setPageOffset(pagingSingleSelection.getStartIndex());
        }
    }

    /**
     * in charge of sorting and paging multiple selections list
     */
    protected void manageMultipleSelections() {

        // create the single selections list from the complete list
        for (TerritoryDto t : territoriesSelection) {
            if (t.getCreator() != null) {
                multipleSelections.add(t);
            }
        }

        int lCount = multipleSelections.size();

        // set member result count
        pagingMultipleSelection.setResultCount(lCount);

        if (lCount > 0) {
            // sorting
            if (multipleSelectionSortCriterionSelected != null) {
                multipleSelectionSortCriterion = multipleSelectionSortCriterionSelected;
                multipleSelectionSortDirection = multipleSelectionSortDirectionSelected;
            }
            Collections.sort(multipleSelections, new SelectionComparator(2, multipleSelectionSortCriterion, multipleSelectionSortDirection));


            // get start and end idx to extract
            Integer lStartIdx = pagingMultipleSelection.getStartIndex() * pagingMultipleSelection.getPageSize();
            Integer lEndIdx = lStartIdx + pagingMultipleSelection.getPageSize();
            if (lEndIdx >= lCount) {
                lEndIdx = lCount;
            }

            // make sub list
            List<TerritoryDto> lSubList = multipleSelections.subList(lStartIdx, lEndIdx);

            // set sub list
            multipleSelections = lSubList;

            // Mantis 3687
            for (TerritoryDto territory : multipleSelections) {
                for (OrganismDto organism : territory.getOrganisms()) {
                    if (organism.getType() == OrganismType.SPEA) {
                        try {
                            TerritoryDto territoryOfOrganism = territoryService.readTerritory(organism.getId(), OrganismType.SPEA);
                            organism.setName(territoryOfOrganism.getName());
                        } catch (SispeaException e) {
                            //Nothing is done
                        }
                    }
                }
            }

            // set page offset
            pagingMultipleSelection.setPageOffset(pagingMultipleSelection.getStartIndex());
        }
    }

//    protected boolean isTerritoryInSelection(TerritoryDto pTerritory) throws SispeaException {
//        boolean lRes;
//
//        try {
//            if (getCurrentUser() == null) {
//                // the user is not authenticated
//                if (getSispeaSession().getSelectedTerritories().indexOf(pTerritory) < 0) {
//                    lRes = false;
//                } else {
//                    lRes = true;
//                }
//
//            } else {
//                // the user is authenticated
//                // read territories
//                List<TerritoryDto> lTemp = referentialService.readUserSelections(getCurrentUser());
//
//                if (lTemp == null || lTemp.size() == 0) {
//                    lRes = false;
//                } else if (lTemp.indexOf(pTerritory) < 0) {
//                    lRes = false;
//                } else {
//                    lRes = true;
//                }
//            }
//        } catch (Exception e) {
//            throw new SispeaException(e);
//        }
//
//        return lRes;
//    }

    /**
     * Toggle sorting direction for single selections
     *
     * @param pCriterion
     * @return
     */
    public Integer toggleSingleSelectionsSortDirection(int pCriterion) {
        Integer lRes;

        try {
            if (pCriterion == singleSelectionSortCriterion) {
                if (singleSelectionSortDirection == 1) {
                    lRes = 0;
                } else {
                    lRes = 1;
                }
            } else {
                lRes = 0;
            }
        } catch (Exception e) {
            logger.error(e);
            lRes = 0;
        }

        return lRes;
    }


    /**
     * Toggle sorting direction for multiple selections
     *
     * @param pCriterion
     * @return
     */
    public Integer toggleMultipleSelectionsSortDirection(int pCriterion) {
        Integer lRes;

        try {
            if (pCriterion == multipleSelectionSortCriterion) {
                if (multipleSelectionSortDirection == 1) {
                    lRes = 0;
                } else {
                    lRes = 1;
                }
            } else {
                lRes = 0;
            }
        } catch (Exception e) {
            logger.error(e);
            lRes = 0;
        }

        return lRes;
    }

    public String getOrganismNameForMultipleSelection() {
        return "";
    }

    public List<TerritoryDto> getTerritoriesSelection() {
        return territoriesSelection;
    }

    public void setTerritoriesSelection(List<TerritoryDto> pTerritoriesSelection) {
        territoriesSelection = pTerritoriesSelection;
    }

    public List<String> getTerritoryIdsSave() {
        return territoryIdsSave;
    }

    public void setTerritoryIdsSave(List<String> pTerritoryIdsSave) {
        territoryIdsSave = pTerritoryIdsSave;
    }

    public String getTerritoryIdSave() {
        return territoryIdSave;
    }

    public void setTerritoryIdSave(String pTerritoryIdSave) {
        territoryIdsSave = new ArrayList<>();
        territoryIdsSave.add(pTerritoryIdSave);
        territoryIdSave = pTerritoryIdSave;
    }

    public List<TerritoryDto> getSingleSelections() {
        return singleSelections;
    }

    public void setSingleSelections(List<TerritoryDto> pSingleSelections) {
        singleSelections = pSingleSelections;
    }

    public List<TerritoryDto> getMultipleSelections() {
        return multipleSelections;
    }

    public void setMultipleSelections(List<TerritoryDto> pMultipleSelections) {
        multipleSelections = pMultipleSelections;
    }

    public PagingDto getPagingSingleSelection() {
        return pagingSingleSelection;
    }

    public PagingDto getPagingMultipleSelection() {
        return pagingMultipleSelection;
    }

    public int getSingleSelectionSortCriterion() {
        return singleSelectionSortCriterion;
    }

    public void setSingleSelectionSortCriterion(int pSingleSelectionSortCriterion) {
        singleSelectionSortCriterion = pSingleSelectionSortCriterion;
    }

    public int getSingleSelectionSortDirection() {
        return singleSelectionSortDirection;
    }

    public void setSingleSelectionSortDirection(int pSingleSelectionSortDirection) {
        singleSelectionSortDirection = pSingleSelectionSortDirection;
    }

    public Integer getSingleSelectionSortCriterionSelected() {
        return singleSelectionSortCriterionSelected;
    }

    public void setSingleSelectionSortCriterionSelected(
            Integer pSingleSelectionSortCriterionSelected) {
        singleSelectionSortCriterionSelected = pSingleSelectionSortCriterionSelected;
    }

    public Integer getSingleSelectionSortDirectionSelected() {
        return singleSelectionSortDirectionSelected;
    }

    public void setSingleSelectionSortDirectionSelected(
            Integer pSingleSelectionSortDirectionSelected) {
        singleSelectionSortDirectionSelected = pSingleSelectionSortDirectionSelected;
    }

    public int getMultipleSelectionSortCriterion() {
        return multipleSelectionSortCriterion;
    }

    public void setMultipleSelectionSortCriterion(
            int pMultipleSelectionSortCriterion) {
        multipleSelectionSortCriterion = pMultipleSelectionSortCriterion;
    }

    public Integer getMultipleSelectionSortCriterionSelected() {
        return multipleSelectionSortCriterionSelected;
    }

    public void setMultipleSelectionSortCriterionSelected(
            Integer pMultipleSelectionSortCriterionSelected) {
        multipleSelectionSortCriterionSelected = pMultipleSelectionSortCriterionSelected;
    }

    public int getMultipleSelectionSortDirection() {
        return multipleSelectionSortDirection;
    }

    public void setMultipleSelectionSortDirection(
            int pMultipleSelectionSortDirection) {
        multipleSelectionSortDirection = pMultipleSelectionSortDirection;
    }

    public Integer getMultipleSelectionSortDirectionSelected() {
        return multipleSelectionSortDirectionSelected;
    }

    public void setMultipleSelectionSortDirectionSelected(
            Integer pMultipleSelectionSortDirectionSelected) {
        multipleSelectionSortDirectionSelected = pMultipleSelectionSortDirectionSelected;
    }

}
