package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.search.MandateOrderByFieldPossibility;
import fr.onema.sispea.service.user.MandateDto;
import fr.onema.sispea.struts.AbstractSispeaAction;
import fr.onema.sispea.struts.user.bean.MandatePagingBean;
import fr.onema.sispea.util.constants.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * This action handles the user mandates.
 *
 * @author CS
 */
public abstract class AbstractUserMandatesAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    /**
     * user's login
     */
    protected String userLogin;

    /**
     * Received mandates
     */
    protected List<MandateDto> mandatesWhereMandated;

    /**
     * The filter / paging information.
     */
    protected MandatePagingBean mandatedInfo;

    /**
     * Given mandates
     */
    protected List<MandateDto> mandatesWhereMandator;

    /**
     * The filter / paging information.
     */
    protected MandatePagingBean mandatorInfo;

    /**
     * mandates to delete
     */
    protected List<String> mandatesToDelete = new ArrayList<>();

    public AbstractUserMandatesAction() {
        mandatedInfo = new MandatePagingBean(MandateOrderByFieldPossibility.service);
        mandatorInfo = new MandatePagingBean(MandateOrderByFieldPossibility.mandatedLogin);
    }

    /**
     * return a formatted string for display only
     *
     * @param pStr
     * @return
     */
    public String formatString(String pStr) {
        //format
        String lRes = StringUtils.formatString(pStr);

        // result
        return lRes;
    }

    public String getUserLogin() {
        return userLogin;
    }

    public void setUserLogin(String pUserLogin) {
        userLogin = pUserLogin;
    }

    public List<MandateDto> getMandatesWhereMandated() {
        return mandatesWhereMandated;
    }

    public void setMandatesWhereMandated(List<MandateDto> pMandatesWhereMandated) {
        mandatesWhereMandated = pMandatesWhereMandated;
    }

    public List<MandateDto> getMandatesWhereMandator() {
        return mandatesWhereMandator;
    }

    public void setMandatesWhereMandator(List<MandateDto> pMandatesWhereMandator) {
        mandatesWhereMandator = pMandatesWhereMandator;
    }

    public List<String> getMandatesToDelete() {
        return mandatesToDelete;
    }

    public void setMandatesToDelete(List<String> pMandatesToDelete) {
        mandatesToDelete = pMandatesToDelete;
    }

    public MandatePagingBean getMandatedInfo() {
        return mandatedInfo;
    }

    public MandatePagingBean getMandatorInfo() {
        return mandatorInfo;
    }
}
