package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.MandateDto;

/**
 * This action handles the user mandates visualization.
 *
 * @author CS
 */
public abstract class AbstractRefuseMandateAction extends AbstractUserMandatesAction {

    private static final long serialVersionUID = 1L;

//    private static final Logger logger = Logger.getLogger(RefuseMandateAction.class);

    /**
     * Mandate to process
     */
    protected MandateDto mandate;

    /**
     * notification message
     */
    protected String message;

//    @Override
//    protected String doExecute() throws Exception {
//
//        if (logger.isDebugEnabled()) {
//            logger.debug("refuse mandate - doExecute");
//        }
//
//        // result
//        return Action.SUCCESS;
//    }

    /**
     * Load a Mandate
     */
    public void loadMandate() throws SispeaException {
        // get mandates to refuse
        mandate = userService.readMandate(mandate.getMandated().getLogin(), mandate.getSpea().getId(), mandate.getMandator().getLogin());
    }

    public MandateDto getMandate() {
        return mandate;
    }

    public void setMandate(MandateDto pMandate) {
        mandate = pMandate;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

}
