package fr.onema.sispea.struts.synthesis.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.util.Map;

/**
 * This action displays the tupology synthesis pages.
 *
 * @author CS
 */
public class ShowTypologySynthesisAction extends AbstractSynthesisAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowTypologySynthesisAction.class);

    protected boolean choosenIndicatorVisible;

    /**
     * Store the criterion name for each criteria from {@link #getCriteria()} method. Keys are translation key
     */
    protected Map<String, String> criterionNameMap;

    @Override
    protected String doExecute() throws Exception {

        //init
        String lRes = Action.SUCCESS;


        if (logger.isDebugEnabled()) {
            logger.debug(getText("fr.onema.sispea.struts.synthesis.action.showTypologySynthesis.debug"));
        }

        // default menu
        openMenu(MenuConstants.MENU_KEY_TYPOLOGY);

        // check parameters
        checkAndGetParameters(false, true);

        // criterion set ?
        if (criterion != null) {
            // do the job
            processBarChart(exercise, indicator, slicesConsolidatedValues, true);
        }

        // slice set ?
        if (slice != null) {
            // do the job
            processScatterChart(slice, true);
        }

        // show menu
        openMenu(getMenuKey(false));

        choosenIndicatorVisible = chosenIndicatorId != null && getVisibility(chosenExerciseId, chosenIndicatorId);

        return lRes;
    }

    public boolean isChoosenIndicatorVisible() {
        return choosenIndicatorVisible;
    }

    public void setChoosenIndicatorVisible(boolean isVisible) {
        this.choosenIndicatorVisible = isVisible;
    }

    /**
     * @return the criterion name from the translation key
     */
    public String getCriterionName(String pCriterionName) {
        return criterionNameMap.get(pCriterionName);
    }

}
