package fr.onema.sispea.struts.synthesis.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.synthesis.ScatterChartDto;
import fr.onema.sispea.service.synthesis.ScatterValueDto;
import fr.onema.sispea.struts.AbstractSispeaAction;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.struts.synthesis.bean.CategoryChartBean;
import fr.onema.sispea.struts.synthesis.bean.CategoryValueBean;
import fr.onema.sispea.struts.synthesis.bean.PieChartBean;
import fr.onema.sispea.struts.synthesis.bean.PieValueBean;
import org.apache.log4j.Logger;

import java.util.Random;


/**
 * This action initializes the synthesis pages.
 *
 * @author CS
 */
public class InitSynthesisAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(InitSynthesisAction.class);

    /**
     * The pie chart generated by the action.
     */
    protected PieChartBean pieChart;

    /**
     * The scatter chart generated by the action.
     */
    protected ScatterChartDto scatterChart;

    /**
     * The category chart generated by the action.
     */
    protected CategoryChartBean categoryChart;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("Initializing synthesis");
        }

        openMenu(MenuConstants.MENU_KEY_SYNTHESIS);

        // Dummy code
        pieChart = new PieChartBean();
        pieChart.setTitle("Developer Preference");
        pieChart.add(new PieValueBean("Java", 55));
        pieChart.add(new PieValueBean("C", 47));
        pieChart.add(new PieValueBean("VB", 38));
        pieChart.add(new PieValueBean("C++", 40));
        pieChart.add(new PieValueBean("Cache", 10));

        // Put the chart into the session so that the JWebChart servlet can access it.
        getSession().put("PIE_CHART", pieChart);

        scatterChart = new ScatterChartDto();
        scatterChart.setTitle("Response Time");
        scatterChart.setWidth(500);
        scatterChart.setHeight(400);
        scatterChart.setXLabel("pages");
        scatterChart.setYLabel("ms");
        scatterChart.setOrientation("H");
        scatterChart.add(new ScatterValueDto("Hits", 10, 787));
        scatterChart.add(new ScatterValueDto("Hits", 23, 655));
        scatterChart.add(new ScatterValueDto("Hits", 500, 555));
        scatterChart.add(new ScatterValueDto("Hits", 78, 345));
        scatterChart.add(new ScatterValueDto("Hits", 1050, 301));
        scatterChart.add(new ScatterValueDto("Hits", 675, 255));
        scatterChart.add(new ScatterValueDto("Hits", 505, 189));
        scatterChart.add(new ScatterValueDto("Hits", 489, 145));
        scatterChart.add(new ScatterValueDto("Hits", 100, 89));
        scatterChart.add(new ScatterValueDto("Hits", 768, 78));
        scatterChart.add(new ScatterValueDto("Hits", 200, 49));
        scatterChart.add(new ScatterValueDto("Hits", 1024, 35));
        scatterChart.add(new ScatterValueDto("Hits", 512, 31));
        scatterChart.add(new ScatterValueDto("Hits", 55, 12));
        scatterChart.setSessionChartName("SCATTER_CHART_INITSYNTHESIS");

        Random random = new Random();
        for (int i = 0; i < 1000; i++) {
            int x = random.nextInt(1100);
            int y = random.nextInt(800);
            scatterChart.add(new ScatterValueDto("Hits", x, y));
        }

        // Put the chart into the session so that the JWebChart servlet can access it.
        getSession().put(scatterChart.getSessionChartName(), scatterChart);

        categoryChart = new CategoryChartBean();
        categoryChart.setTitle("Year to Date Sales (REV) $'b");
        categoryChart.setWidth(700);
        categoryChart.setHeight(250);
        categoryChart.setXLabel("$'b");

        categoryChart.add(new CategoryValueBean("Actual", "UK", 65.9));
        categoryChart.add(new CategoryValueBean("Budget", "UK", 64.8));
        categoryChart.add(new CategoryValueBean("Variance", "UK", 1.1));

        categoryChart.add(new CategoryValueBean("Actual", "Ireland", 55.2));
        categoryChart.add(new CategoryValueBean("Budget", "Ireland", 54.9));
        categoryChart.add(new CategoryValueBean("Variance", "Ireland", 0.4));

        categoryChart.add(new CategoryValueBean("Actual", "US", 155.5));
        categoryChart.add(new CategoryValueBean("Budget", "US", 147.7));
        categoryChart.add(new CategoryValueBean("Variance", "US", 7.8));

        categoryChart.add(new CategoryValueBean("Actual", "Total", 276.6));
        categoryChart.add(new CategoryValueBean("Budget", "Total", 267.4));
        categoryChart.add(new CategoryValueBean("Variance", "Total", 9.2));

        // Put the chart into the session so that the JWebChart servlet can access it.
        getSession().put("CATEGORY_CHART", categoryChart);

        return SUCCESS;
    }

    public String getChartServletUrl() {
        return getOption("sispea.chart.servlet");
    }

    public PieChartBean getPieChart() {
        return pieChart;
    }

    public ScatterChartDto getScatterChart() {
        return scatterChart;
    }

    public CategoryChartBean getCategoryChart() {
        return categoryChart;
    }
}
