package fr.onema.sispea.struts.search.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.data.SPEALotStatus;
import fr.onema.sispea.service.referential.SPEADto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.referential.TerritoryPairDto;
import fr.onema.sispea.service.referential.TerritoryType;
import fr.onema.sispea.service.search.SearchTerritoryDto;
import fr.onema.sispea.service.user.UserType;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


public class PredefinedSpeaSearchAction extends AbstractSearchTerritoryAction implements Serializable {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(PredefinedSpeaSearchAction.class);

//    /**
//     * The SearchTerritoryBean returned by the action.
//     */
//    protected SearchTerritoryDto searchTerritoryBean = null;
//
//    /**
//     * The exercise
//     */
//    protected ExerciseDto exercise = null;

    /**
     * The territory type
     */
    protected TerritoryType territoryType;

    /**
     * The user territory
     */
    protected TerritoryDto userTerritory;

    /**
     * The lot status
     */
    protected SPEALotStatus lotStatus;

    /**
     * The spea list corresponding to result territory list.
     */
    protected List<SPEADto> speaList;

    /**
     * The territory name
     */
    protected String territoryName;

    protected Map<Integer, String> speaLotStatusMap;

    @Override
    protected String doExecute() throws Exception {

        String nextPage = SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("PredefinedSpeaSearchAction");
        }

        // set the menu
        openMenu(MenuConstants.MENU_KEY_SEARCH_TERRITORIES);


        // prepare search
        exercise = exerciseService.getCurrentExercise();
        territoryType = TerritoryType.SPEA;
        lotStatus = SPEALotStatus.Published;
        searchForUser = true;
        userTerritory = getCurrentUser().getTerritory();

        // search for user's departments
        List<TerritoryDto> lTerritories = new ArrayList<>();
        if (getDisplayDepartment()) {
            lTerritories = territoryService.readDepartmentsFromTerritory(userTerritory, exercise);
            if (lTerritories.size() > 0) {
                territoryName = lTerritories.get(0).getName();
            }
        } else {
            lTerritories.add(userTerritory);
            territoryName = userTerritory.getName();
        }

        // search for published Speas of those departments
        List<TerritoryPairDto> lTerritoryPairs = territoryService.readPublishedSpeasFromTerritories(lTerritories, exercise);

        // populate result list
        searchTerritoryBean.setTerritoryResults(lTerritoryPairs);

        // set total result
        paging.setResultCount(lTerritoryPairs.size());

        // Get the start and end indexes to extract
        Integer startIndex = paging.getStartIndex() * paging.getPageSize();
        Integer endIndex = startIndex + paging.getPageSize();
        if (endIndex >= lTerritoryPairs.size()) {
            endIndex = lTerritoryPairs.size();
        }

        // Make sub list
        List<TerritoryPairDto> lSubList = lTerritoryPairs.subList(startIndex, endIndex);

        // build SPEA list
        speaList = buildSPEAListFromTerritoryResult(lSubList, exercise);

        // Set that a service search has been performed.
        searchTerritoryBean.setSearchDone(true);

        paging.setPageOffset(paging.getStartIndex());

        speaLotStatusMap = computeSpeaLotStatusMap(speaList, exercise.getId());

        return nextPage;
    }

    public boolean getDisplayDepartment() {
        return getCurrentUser().getType() == UserType.SPEA
               || getCurrentUser().getType() == UserType.Collectivity;
    }

    public SearchTerritoryDto getSearchTerritoryBean() {
        return searchTerritoryBean;
    }

    public void setSearchTerritoryBean(SearchTerritoryDto pSearchTerritoryBean) {
        searchTerritoryBean = pSearchTerritoryBean;
    }

//    public ExerciseDto getExercise() {
//        return exercise;
//    }
//
//
//    public void setExercise(ExerciseDto pExercise) {
//        exercise = pExercise;
//    }


    public TerritoryType getTerritoryType() {
        return territoryType;
    }


    public void setTerritoryType(TerritoryType pTerritoryType) {
        territoryType = pTerritoryType;
    }


    public SPEALotStatus getLotStatus() {
        return lotStatus;
    }


    public void setLotStatus(SPEALotStatus pLotStatus) {
        lotStatus = pLotStatus;
    }


    public List<SPEADto> getSPEAList() {
        return speaList;
    }

    public void setSPEAList(List<SPEADto> pList) {
        speaList = pList;
    }

//    public UserDto getUser() {
//        return user;
//    }

    public TerritoryDto getUserTerritory() {
        return userTerritory;
    }

    public void setUserTerritory(TerritoryDto pUserTerritory) {
        userTerritory = pUserTerritory;
    }

    public String getTerritoryName() {
        return territoryName;
    }

    public void setTerritoryName(String pTerritoryName) {
        territoryName = pTerritoryName;
    }

    public String getSpeaLotStatusAsString(Integer pSpeaId) {
        String lRes = "";
        if (pSpeaId != null) {
            lRes = speaLotStatusMap.get(pSpeaId);
        }
        return lRes;
    }
}
