package fr.onema.sispea.struts.search.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.common.PagingDto;
import fr.onema.sispea.service.data.SPEALotStatus;
import fr.onema.sispea.service.referential.OrganismDto;
import fr.onema.sispea.service.referential.SPEADto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.referential.TerritoryPairDto;
import fr.onema.sispea.service.referential.TerritoryType;
import fr.onema.sispea.service.search.SearchTerritoryResultDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.util.constants.SispeaConstants;
import org.apache.log4j.Logger;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * This action handles the territory searching.
 *
 * @author CS
 */
public class PerformSearchTerritoryAction extends AbstractSearchTerritoryAction implements Serializable {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(PerformSearchTerritoryAction.class);

    /**
     * numAction : the num of request for action.
     */
    protected int numAction;

    /**
     * ID of the mixed territory to remove.
     */
    protected String territoryIdSave;

    /**
     *
     */
    protected TerritoryDto selection;

    /**
     * The spea list corresponding to result territory list.
     */
    protected List<SPEADto> speaList;

    @Override
    protected String doExecute() throws Exception {

        String nextPage = SUCCESS;

        // set the menu
        if (searchingForUserTerritory()) {
            openMenu(MenuConstants.MENU_KEY_MYUSERS);
        } else if (searchingForTerritoryOrganism()) {
            openMenu(MenuConstants.MENU_KEY_SEE_TERRITORY);
        } else {
            openMenu(MenuConstants.MENU_KEY_SEARCH_TERRITORIES);
        }


        // no right to check
        if ((submitValue != null) && (submitValue.equals(getText("fr.onema.sispea.jsp.user.myRequestSave.goSearch")))) {
            // get the selected search
            searchTerritoryBean = getMySearchsTerritorys().get(numAction);
            // set it to non initial state to force search
            searchTerritoryBean.setIsInitialState(false);
        }

        try {

            // test searchTerritoryBean_
            if (searchTerritoryBean == null || ((searchTerritoryBean.getResultType() == null) && (searchTerritoryBean.getSimpleResultType() == null))) {
                throw new SispeaException(getText("fr.onema.sispea.jsp.search.searchTerritory.errors.wrongResultType"));
            }

            // FIXME AThimel 13/07/15 Is it the good location to check exercise ?
            checkExercise();

            // Do we have an incoming form?
            // The form object is loaded and set by spring, but the page
            // sets the isInitialState attribute to false
            if (searchTerritoryBean.getIsInitialState()) {
                // The form must be found in the session
                searchTerritoryBean = getSispeaSession().getSearchTerritory();
            } else {
                // Add the territory search parameters to the session
                getSispeaSession().setSearchTerritory(searchTerritoryBean);
            }

            // retrieve current selection
            if (searchingForFillingMultipleSelection()) {
                Integer lSelectionTerritoryId;
                try {
                    // Test if the selection ID is a valid integer.
                    lSelectionTerritoryId = Integer.parseInt(selectionId);
                } catch (NumberFormatException nfe) {
                    throw new SispeaException(getText("fr.onema.sispea.jsp.fixRef.showTerritory.error.invalidTerritoryId"));
                }
                selection = territoryService.readTerritory(lSelectionTerritoryId);
            }


            // no right to check
            if ((submitValue != null) && (submitValue.equals(getText("fr.onema.sispea.common.jsp.removeTerritory")))) {
                try {
                    // Test if the Territory ID is a valid integer.
                    Integer lRemoveTerritoryId = Integer.parseInt(territoryIdSave);

                    // Delete this territory.
                    territoryService.removeTerritoryById(lRemoveTerritoryId);

                } catch (NumberFormatException nfe) {
                    throw new SispeaException(getText("fr.onema.sispea.jsp.fixRef.showTerritory.error.invalidTerritoryId"));
                } catch (SispeaException lEx) {
                    throw new SispeaException(getText("fr.onema.sispea.jsp.fixRef.showTerritory.error.invalidTerritoryId"));
                }
            }

            // filter search results type allowed
            TerritoryType resultType = null;
            if (searchTerritoryBean.getIsSimpleSearch()) {
                if (searchTerritoryBean.getSimpleResultType() != null) {
                    resultType = TerritoryType.parse(searchTerritoryBean.getSimpleResultType().name());
                }
            } else {
                if (searchTerritoryBean.getResultType() != null) {
                    resultType = TerritoryType.parse(searchTerritoryBean.getResultType().name());
                }
            }

            // check result type
            if (resultType == null) {
                addActionError(getText("fr.onema.sispea.jsp.search.searchTerritory.errors.wrongResultType"));
                nextPage = ERROR;
            } else {
                if (!resultType.getResultable()) {
                    addActionError(getText("fr.onema.sispea.jsp.search.searchTerritory.errors.unknownResultType",
                                           new String[]{getText(resultType.getLabelKey())}));
                    nextPage = ERROR;
                }
            }

            try {

                // prepare search
                Integer lExerciseId = SispeaConstants.INVALID_INT_ID;
                SPEALotStatus lLotStatus = null;
                TerritoryType lSearchTerritoryType;
                String lResultKeywords;
                String lSearchKeywords;
                // if simple search, change search params
                if (searchTerritoryBean.getIsSimpleSearch()) {
                    lSearchTerritoryType = resultType;
                    lResultKeywords = searchTerritoryBean.getSimpleResultKeywords();
                    lSearchKeywords = lResultKeywords;
                } else {
                    lSearchTerritoryType = searchTerritoryBean.getTerritoryType();
                    lResultKeywords = searchTerritoryBean.getResultKeywords();
                    lSearchKeywords = searchTerritoryBean.getSearchKeywords();
                    lExerciseId = searchTerritoryBean.getExerciseId();
                    lLotStatus = searchTerritoryBean.getLotStatus();
                }

                // If it is the first page, then get the number of results too
                if (paging.getPageOffset() == PagingDto.FIRST_PAGE - 1) {
                    int resultCount = territoryService.countTerritories(lSearchTerritoryType,
                                                                        lSearchKeywords,
                                                                        lResultKeywords,
                                                                        resultType,
                                                                        lExerciseId,
                                                                        lLotStatus);
                    paging.setResultCount(resultCount);
                    if (logger.isDebugEnabled()) {
                        logger.debug(resultCount + " territorie(s) found");
                    }
                }

                // Get results : check if user wants to search on its reference territory
                List<SearchTerritoryResultDto> lResult = territoryService.search(lSearchTerritoryType,
                                                                                 lSearchKeywords,
                                                                                 lResultKeywords,
                                                                                 resultType,
                                                                                 lExerciseId,
                                                                                 lLotStatus,
                                                                                 false,
                                                                                 paging.getStartIndex() * paging.getPageSize(),
                                                                                 paging.getPageSize());
                Collection<TerritoryPairDto> territoryPairs = SearchTerritoryResultDto.getPairs(lResult);

                // build SPEA list
                speaList = buildSPEAListFromTerritoryResult(territoryPairs, exercise);

                // populate result list
                searchTerritoryBean.setTerritoryResults(territoryPairs);

                // Set that a service search has been performed.
                searchTerritoryBean.setSearchDone(true);
                paging.setPageOffset(paging.getStartIndex());

            } catch (SispeaException lEx) {
                // We are no more at initial state.
                searchTerritoryBean.setIsInitialState(true);
                // reset results
                searchTerritoryBean.setTerritoryResults(new ArrayList<TerritoryPairDto>());
                // propagate
                throw new SispeaException(lEx.getMessage());
            }


        } catch (SispeaException lEx) {
            String lMessage = getText("fr.onema.sispea.jsp.search.searchTerritory.errors.general", "", lEx.getMessage());
            if (logger.isDebugEnabled()) {
                logger.debug(lMessage, lEx);
            }
            addActionError(lMessage);
            nextPage = INPUT;
        }

        // result
        return nextPage;
    }

    /**
     * @param pTerritoryId
     * @return true if the territory is already included in the current selection
     */
    public boolean isSelectionContainsTerritory(String pTerritoryId) {
        boolean isSelectionContainsTerritory = false;
        if ((selectionId != null) && (!"".equals(selectionId))) {
            Integer iTerritoryId = Integer.parseInt(pTerritoryId);

            for (TerritoryPairDto lTerr : searchTerritoryBean.getTerritoryResults()) {
                if (lTerr.getChildTerritoryId().equals(iTerritoryId)) {
                    for (OrganismDto lOrg : lTerr.getChildTerritory().getOrganisms()) {
                        if (selection.getOrganisms().contains(lOrg)) {
                            return true;
                        }
                    }
                }
            }
        }
        return isSelectionContainsTerritory;
    }

    // Getters and setters

    public int getNumAction() {
        return numAction;
    }

    public void setNumAction(int pNumAction) {
        numAction = pNumAction;
    }

    public String getTerritoryIdSave() {
        return territoryIdSave;
    }

    public void setTerritoryIdSave(String pTerritoryIdSave) {
        territoryIdSave = pTerritoryIdSave;
    }

    public TerritoryDto getSelection() {
        return selection;
    }

    public void setSelection(TerritoryDto pSelection) {
        selection = pSelection;
    }

    public List<SPEADto> getSPEAList() {
        return speaList;
    }

}
