package fr.onema.sispea.struts.search.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.data.SPEALotStatus;
import fr.onema.sispea.service.exchange.predefinedSpea.PredefinedSpeaSearchExportParameters;
import fr.onema.sispea.service.exchange.thread.AsynchronousService;
import fr.onema.sispea.service.referential.TerritoryType;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;


/**
 * This action handles the users download.
 * It allows the end user to download users props.
 *
 * @author CS
 */
public class DownloadPredefinedSpeaSearchAction extends PredefinedSpeaSearchAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(DownloadPredefinedSpeaSearchAction.class);

    @Autowired
    @Qualifier("predefinedSpeaExportGeneratorService")
    protected transient AsynchronousService batchGenerator;

    @Override
    protected String doExecute() throws Exception {

        String view;

        if (logger.isDebugEnabled()) {
            logger.debug("download predefined spea search action - do execute");
        }

        // Load the data so the current page can be re-displayed
        view = super.doExecute();

        // Prepare the export parameters
        PredefinedSpeaSearchExportParameters parameters = new PredefinedSpeaSearchExportParameters();
        parameters.setFileName(getText("fr.onema.sispea.struts.search.action.DownloadPredefinedSpeaSearchAction"));
        parameters.setCurrentExercise(exerciseService.getCurrentExercise());
        parameters.setTerritoryType(TerritoryType.SPEA);
        parameters.setLotStatus(SPEALotStatus.Published);
        parameters.setUserTerritory(getCurrentUser().getTerritory());
        parameters.setUser(getCurrentUser());

        // Generate the data model
        batchGenerator.execute(parameters);

        // message
        addActionMessage(getText("fr.onema.sispea.struts.search.action.DownloadPredefinedSpeaSearchAction.message"));

        // result
        return view;
    }

}
