package fr.onema.sispea.struts.referential.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.SispeaInputException;
import fr.onema.sispea.service.data.ComputeScale;
import fr.onema.sispea.service.data.DCValueDto;
import fr.onema.sispea.service.data.DataDetailValueDto;
import fr.onema.sispea.service.data.DataDto;
import fr.onema.sispea.service.data.DataLotDto;
import fr.onema.sispea.service.data.DataValueDto;
import fr.onema.sispea.service.data.IndicatorValueDto;
import fr.onema.sispea.service.data.Reliability;
import fr.onema.sispea.service.data.SPEALotDto;
import fr.onema.sispea.service.data.VPValueDto;
import fr.onema.sispea.service.data.Verification;
import fr.onema.sispea.struts.referential.action.AbstractSpeaIndicatorsAction;
import fr.onema.sispea.struts.referential.xml.XmlGroupType;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;


/**
 * This class is a support class to read xml group from a xml file
 *
 * @author CS
 */
public class XmlGroupValue extends XmlGroup implements Cloneable {

    private static final long serialVersionUID = 1L;

    /**
     * Vp's codes autocomputable
     */
    private static final List<String> VP_AUTOCOMPUTABLE = Arrays.asList("VP.177", "VP.178", "VP.179");

    private static final List<String> VP_DETAIL_AUTOCOMPUTABLE = Arrays.asList("VP.059", "VP.077", "VP.062");

    /**
     * the value
     */
    protected DataValueDto value = null;

    /**
     * the value
     */
    protected DataValueDto oldValue = null;

    /**
     * the indicator name
     */
    protected String name = null;

    /**
     * the indicator unit
     */
    protected String unit = null;

    /**
     * the indicator reliability
     */
    protected Reliability reliability = null;

    /**
     * the indicator comment
     */
    protected String comment = null;

    /**
     * the indicator opinion
     */
    protected String opinion = null;

    /**
     * the indicator verification
     */
    protected Verification verification = null;

    /**
     * editing mode
     */
    protected boolean editing = false;

    /**
     * visible mode
     */
    protected boolean visible = true;

    /**
     * editable mode
     */
    protected boolean editable = false;

    /**
     * auto compute formula
     */
    protected Boolean autoCompute = false; // AThimel 29/06/15 "null" may be used (cf showSpeaData.jsp)

    /**
     * display auto compute
     */
    protected boolean displayAutoCompute = false;

    /**
     * Default constructor.
     */
    public XmlGroupValue() {
        super();
    }

    /**
     * copy constructor.
     */
    public XmlGroupValue(XmlGroupValue pXmlGroup) {
        super(pXmlGroup);
    }

    /**
     * return values for each slice found
     *
     * @return
     */
    public static List<XmlGroupValue> updateXmlGroupTablePriceValue(SPEALotDto pLot, int pCompetenceId, Boolean pHasViewRight,
                                                                    XmlGroupValue pXmlGroupValue, AbstractSpeaIndicatorsAction pAction) {

        // init
        List<XmlGroupValue> lRes = null;

        if (pXmlGroupValue != null && (pXmlGroupValue.isSliceValue() || pXmlGroupValue.isPriceValue())) {

            // init result
            lRes = new ArrayList<>();

            // find slices in Lot
            ArrayList<DataDetailValueDto> lLotValues = pLot.getDataDetailSliceValueByCode(pXmlGroupValue.getCode());

            // sort slices by upper bound
            Collections.sort(lLotValues);

            // iterate to create group values
            for (DataDetailValueDto lDataDetailValue : lLotValues) {
                // updated group value
                XmlGroupValue lUpdatedXmlGroupValue = pXmlGroupValue.clone();

                // copy values
                if (lDataDetailValue.getDataDetail() != null) {
                    lUpdatedXmlGroupValue.setName(pAction.getText(lDataDetailValue.getDataDetail().getName(), "",
                                                                  new String[]{lDataDetailValue.getLowerBound().toString(), lDataDetailValue.getUpperBound().toString()}));
                    if (lUpdatedXmlGroupValue.getDetailValue() != null) {
                        lUpdatedXmlGroupValue.getDetailValue().setFormattedFloatValue(lDataDetailValue.getFormattedFloatValue());
                    }
                    lUpdatedXmlGroupValue.setCode(lDataDetailValue.getDataDetail().getCode());
                    if (lDataDetailValue.getDataDetail().getUnit() != null) {
                        lUpdatedXmlGroupValue.setUnit(lDataDetailValue.getDataDetail().getUnit().getSymbol());
                    }
                }
                lUpdatedXmlGroupValue.setComment(lDataDetailValue.getComment());
                lUpdatedXmlGroupValue.setEditing(false);
                lUpdatedXmlGroupValue.setValue(lDataDetailValue);
                if (lUpdatedXmlGroupValue.isSliceValue()) {
                    lUpdatedXmlGroupValue.setEditable(true);
                }

                // add to result
                lRes.add(lUpdatedXmlGroupValue);
            }
        }

        // result
        return lRes;
    }

    /**
     * updates the group value and returns it updated
     *
     * @return
     */
    public static XmlGroupValue updateXmlGroupTableValue(DataLotDto pLot, DataLotDto pOldLot, int pCompetenceId, Boolean pHasViewRight,
                                                         XmlGroupValue pXmlGroupValue, AbstractSpeaIndicatorsAction pAction) {

        // init
        XmlGroupValue lXmlGroupValue = pXmlGroupValue;

        // check if not null
        if (lXmlGroupValue != null) {

            // update this value
            String code = lXmlGroupValue.getCode();
            DataValueDto lDataValue = pLot.getDataValueByCode(code);

            // if data value nul -> do not display
            if (lDataValue == null) {
                // no value -> may be a simple title ?
                if (!lXmlGroupValue.isTitleValue()) {
                    // no value -> hide
                    lXmlGroupValue = null;
                }
            } else if (!lXmlGroupValue.canView(pHasViewRight, lDataValue)) {
                // can't view -> hide
                lXmlGroupValue = null;
            } else {

                // map values and so
                lXmlGroupValue.setValue(lDataValue);
                // Value from the previous exercise
                if (pOldLot != null) {
                    lXmlGroupValue.setOldValue(pOldLot.getDataValueByCode(code));
                }


                lXmlGroupValue.setComment(lDataValue.getComment());

                // Editing mode
                lXmlGroupValue.setEditing(false);

                // wich kind of value ?
                if (lDataValue.getClass().equals(VPValueDto.class)) {
                    VPValueDto lPVValue = (VPValueDto) lDataValue;
                    // Vp -> map infos
                    lXmlGroupValue.setName(lPVValue.getVp().getName());
                    lXmlGroupValue.setUnit(lPVValue.getVp().getUnit().getSymbol());
                    lXmlGroupValue.setEditable(true);
                    if (lPVValue.getAutoCompute() != null) {
//VP AUTO COMPUTE
                        if (XmlGroupValue.VP_DETAIL_AUTOCOMPUTABLE.contains(lPVValue.getVp().getCode())) {
                            lXmlGroupValue.setDisplayAutoCompute(true);
                        } else {
                            lXmlGroupValue.setDisplayAutoCompute(false);
                        }
//END VP AUTO COMPUTE
                        lXmlGroupValue.setAutoCompute(lPVValue.getAutoCompute());
                    } else {
                        // check if VP is autocomputable
                        if (XmlGroupValue.VP_AUTOCOMPUTABLE.contains(lPVValue.getVp().getCode())) {
                            lXmlGroupValue.setAutoCompute(true);
                        } else {
                            lXmlGroupValue.setAutoCompute(null);
                        }
                    }

                } else if (lDataValue.getClass().equals(DCValueDto.class)) {
                    DCValueDto lValue = (DCValueDto) lDataValue;
                    // Cd -> map
                    lXmlGroupValue.setName(lValue.getDc().getName());
                    if (lValue.getDc().isOriginatedFromVP()) {
                        lXmlGroupValue.setUnit(lValue.getDc().getUnit().getSymbol());
                    } else {
                        lXmlGroupValue.setUnit(lValue.getUnit());
                    }
                    lXmlGroupValue.setEditable(true);

                } else if (lDataValue.getClass().equals(IndicatorValueDto.class)) {
                    IndicatorValueDto lIndicatorValue = (IndicatorValueDto) lDataValue;
                    // Indicator -> map
                    lXmlGroupValue.setName(lIndicatorValue.getIndicator().getName());
                    lXmlGroupValue.setUnit(lIndicatorValue.getIndicator().getUnit().getSymbol());
                    lXmlGroupValue.setReliability(lIndicatorValue.getReliability());
                    lXmlGroupValue.setVerification(lIndicatorValue.getVerification());
                    lXmlGroupValue.setEditable(lIndicatorValue.getIndicator().isEditable());

                    // auto compute : if indicator is idem VP then no auto compute
                    if (lIndicatorValue.getIndicator().isIdemVP() && lIndicatorValue.getIndicator().getComputeMinScale() == ComputeScale.SPEA) {
                        lXmlGroupValue.setAutoCompute(null);
                    } else if (!lIndicatorValue.getIndicator().isEditable()) {
                        lXmlGroupValue.setAutoCompute(null);
                    } else if (lIndicatorValue.getIndicator().getFormuleIP() == null || lIndicatorValue.getIndicator().getFormuleIP().equalsIgnoreCase("null")) {
                        lXmlGroupValue.setAutoCompute(null);
                    } else {
                        lXmlGroupValue.setAutoCompute(lIndicatorValue.getAutoCompute());
                    }
                    // opinion    just for user with edit or check right
                    if (pHasViewRight) {
                        lXmlGroupValue.setOpinion(lIndicatorValue.getOpinion());
                    } else {
                        lXmlGroupValue.setOpinion(null);
                    }
                }
            }
        }

        return lXmlGroupValue;
    }

    /**
     * updates lot with group data
     *
     * @param pXmlGroupValue
     * @param pLot
     * @return
     * @throws SispeaException
     */
    protected static DataLotDto updateLotWithValue(XmlGroupValue pXmlGroupValue, DataLotDto pLot) throws SispeaException, SispeaInputException {

        // init
        DataLotDto lRes = pLot;

        // copy values
        if (pXmlGroupValue != null && pXmlGroupValue.getValue() != null) {

            // init
            DataValueDto lLotValue;

            // search for slice value if needed, and adds it if not found
            if (pXmlGroupValue.isSliceValue()) {
                // search for slice
                SPEALotDto lSpeaLot = (SPEALotDto) lRes;
                DataDetailValueDto lDataDetailValue = (DataDetailValueDto) pXmlGroupValue.getValue();

                // update comment
                if (pXmlGroupValue.getComment() != null && pXmlGroupValue.getComment().length() > 255) {
                    throw new SispeaInputException("fr.onema.sispea.error.field.tooLong", pXmlGroupValue.getComment(), "255");
                }
                lDataDetailValue.setComment(pXmlGroupValue.getComment());

                // lot value ?
                lLotValue = lSpeaLot.getDataDetailValueByUpperBoundAndCode(lDataDetailValue.getUpperBound(), pXmlGroupValue.getCode());

                // if value is null then add a new data detail slice value corresponding to this upper bound
                if (lLotValue == null) {
                    lSpeaLot.addDataDetailValue(lDataDetailValue);
                } else {
                    lLotValue.setComment(pXmlGroupValue.getComment());
                }
            } else if (pXmlGroupValue.isPriceValue()) {
                lLotValue = ((SPEALotDto) lRes).getDataDetailValueByCode(pXmlGroupValue.getCode());
            } else {
                lLotValue = lRes.getDataValueByCode(pXmlGroupValue.getCode());
            }

            if (lLotValue == null && pLot.getClass().equals(SPEALotDto.class)) {
                // lot
                SPEALotDto lSpeaLot = (SPEALotDto) lRes;
                // search for data detail
                if (pXmlGroupValue.isPriceValue()) {
                    lLotValue = lSpeaLot.getDataDetailValueByCode(pXmlGroupValue.getCode());
                } else if (pXmlGroupValue.isSliceValue()) {
                    DataDetailValueDto lXmlValue = (DataDetailValueDto) pXmlGroupValue.getValue();
                    lLotValue = lSpeaLot.getDataDetailValueByUpperBoundAndCode(lXmlValue.getUpperBound(), pXmlGroupValue.getCode());
                }
            }
            if (lLotValue == null) {
                throw new SispeaException("An input value doesn''t exist in SPEA Lot !");
            }

            // copy params
            lLotValue.setValue(pXmlGroupValue.getValue().getValue());
            if (pXmlGroupValue.getComment() != null && pXmlGroupValue.getComment().length() > 255) {
                throw new SispeaInputException("fr.onema.sispea.error.field.tooLong", pXmlGroupValue.getComment(), "255");
            }
            lLotValue.setComment(pXmlGroupValue.getComment());

            // wich value type ?
            if (pXmlGroupValue.isIndicatorValue()) {
                // update indicator value specific attributes
                IndicatorValueDto lIndicatorLotValue = (IndicatorValueDto) lLotValue;
                lIndicatorLotValue.setAutoCompute(pXmlGroupValue.getAutoCompute());
                lIndicatorLotValue.setOpinion(pXmlGroupValue.getOpinion());
                lIndicatorLotValue.setReliability(pXmlGroupValue.getReliability());
            } else if (pXmlGroupValue.isContextValue()) {
                // update data context value specific attributes
                DCValueDto lCDValue = (DCValueDto) lLotValue;
                lCDValue.setUnit(pXmlGroupValue.getUnit());
            } else if (pXmlGroupValue.isVariableValue()) {
                // update data context value specific attributes
                VPValueDto lPVValue = (VPValueDto) lLotValue;
                lPVValue.setAutoCompute(pXmlGroupValue.getAutoCompute());
            }

        }

        // result
        return lRes;
    }

    /**
     * clone an XmlGroupValue Object
     */
    public XmlGroupValue clone() {

        // init
        XmlGroupValue lRes = new XmlGroupValue();

        // copy attributes to the clone
        lRes.copy(this);

        // result
        return lRes;
    }

    /**
     * copy parameter into this
     */
    public void copy(XmlGroupValue pXmlGroupValue) {
        // copy parent attributes
        super.copy(pXmlGroupValue);

        // copy this attributes
        setValue(pXmlGroupValue.getValue());
        setName(pXmlGroupValue.getName());
        setUnit(pXmlGroupValue.getUnit());
        setReliability(pXmlGroupValue.getReliability());
        setComment(pXmlGroupValue.getComment());
        setOpinion(pXmlGroupValue.getOpinion());
        setVerification(pXmlGroupValue.getVerification());
        setEditing(pXmlGroupValue.isEditing());
        setVisible(pXmlGroupValue.isVisible());
        setEditable(pXmlGroupValue.isEditable());
        setAutoCompute(pXmlGroupValue.getAutoCompute());
    }

    /**
     * return true if table is empty, false else
     *
     * @return
     */
    public boolean isEmpty() {

        // init
        boolean lRes = true;

        // check if this group is empty
        if (visible) {
            if ((isIndicatorValue()
                 || isVariableValue()
                 || isContextValue()
                 || isPriceValue()
                 || isSliceValue())
                && (value != null)) {
                lRes = false;
            }
            if (isTitleValue()) {
                lRes = false;
            }
        }

        // result
        return lRes;
    }

    /**
     * return true if table contains indicator
     *
     * @return
     */
    public boolean containsIndicator() {
        return isIndicatorValue();
    }

    /**
     * return true if user can view this value
     *
     * @param pHasViewRight
     */
    protected boolean canView(Boolean pHasViewRight, DataValueDto pDataValue) {

        // init
        boolean lRes = false;

        // has view right ?
        if (pHasViewRight) {
            // has view right -> can view !
            lRes = true;
        } else {
            // don't has view right -> check value type
            // can view indicator and real data context
            if (isIndicatorValue()) {
                lRes = true;
            } else if (isContextValue()) {
                // check if vp
                DCValueDto lValue = (DCValueDto) pDataValue;
                if ((lValue != null) && (lValue.getDc() != null) && (!lValue.getDc().isOriginatedFromVP())) {
                    lRes = true;
                }
            }
        }

        // result
        return lRes;

    }

    /**
     * Returns true if this table contains the data code
     *
     * @param pDatum
     * @return
     */
    public boolean containsData(DataDto pDatum) {

        // init
        boolean lContains = pDatum.getCode().equals(code);

        // result
        return lContains;
    }

    // Getters and setters

    public DataValueDto getValue() {
        return value;
    }

    public void setValue(VPValueDto pValue) {
        value = pValue;
    }

    public void setValue(DataValueDto pValue) {
        value = pValue;
    }

    public DataDetailValueDto getDetailValue() {
        return (DataDetailValueDto) value;
    }

    public void setValue(DataDetailValueDto pValue) {
        value = pValue;
    }

    public String getName() {
        return name;
    }

    public void setName(String pName) {
        name = pName;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String pUnit) {
        unit = pUnit;
    }

    public Reliability getReliability() {
        return reliability;
    }

    public void setReliability(Reliability pReliability) {
        reliability = pReliability;
    }

    public String getReliabilityName() {
        return reliability.name();
    }

    public void setReliabilityName(String pReliabilityName) throws SispeaException {
        reliability = Reliability.parse(pReliabilityName);
    }


    public String getComment() {
        return comment;
    }

    public void setComment(String pComment) {
        comment = pComment;
    }

    public Verification getVerification() {
        return verification;
    }

    public void setVerification(Verification pVerification) {
        verification = pVerification;
    }

    public boolean isVisibleIfPublished() {
        return (type.equals(XmlGroupType.DataIndicator.getId()));
    }

    public String getOpinion() {
        return opinion;
    }

    public void setOpinion(String pOpinion) {
        opinion = pOpinion;
    }

    public DataValueDto getOldValue() {
        return oldValue;
    }

    public void setOldValue(DataValueDto pOldValue) {
        oldValue = pOldValue;
    }

    public boolean isEditing() {
        return editing;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    public boolean isVisible() {
        return visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isEditable() {
        return editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public Boolean getAutoCompute() {
        return autoCompute;
    }

    public void setAutoCompute(Boolean autoCompute) {
        this.autoCompute = autoCompute;
    }

    public boolean isDisplayAutoCompute() {
        return displayAutoCompute;
    }

    public void setDisplayAutoCompute(boolean displayAutoCompute) {
        this.displayAutoCompute = displayAutoCompute;
    }
}
