package fr.onema.sispea.struts.referential.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.SispeaInputException;
import fr.onema.sispea.service.data.DataDto;
import fr.onema.sispea.service.data.EquipmentLotDto;
import fr.onema.sispea.service.data.SPEALotDto;
import fr.onema.sispea.struts.referential.action.AbstractSpeaIndicatorsAction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;


/**
 * This class is a support class to read xml group from a xml file
 *
 * @author CS
 */
public class XmlGroupTableValue extends XmlGroupValue {

    private static final long serialVersionUID = 1L;

    /**
     * the group value code to toggle with
     */
    protected String toggleWith = null;

    /**
     * the group value code to toggle with
     */
    protected Boolean visibleIfPublished = null;

    /**
     * xml sub group list
     */
    protected List<XmlGroupTableDetail> groupTableDetails = new ArrayList<>();

    public XmlGroupTableValue() {
        super();
    }

    public XmlGroupTableValue(XmlGroupTableValue pXmlGroup) {
        super(pXmlGroup);
    }

    /**
     * updates the table value group and returns it updated
     *
     * @return
     * @throws SispeaException
     */
    public static XmlGroupTableValue updateXmlGroupTableValue(SPEALotDto pLot, SPEALotDto pOldLot, int pCompetenceId, Boolean pHasViewRight,
                                                              XmlGroupTableValue pXmlGroupTableValue, AbstractSpeaIndicatorsAction pAction) throws SispeaException {

        // init
        XmlGroupTableValue lXmlGroupTableValue = pXmlGroupTableValue;

        if (lXmlGroupTableValue != null) {

            // update value
            XmlGroupValue lXmlGroupValue = lXmlGroupTableValue;
            lXmlGroupTableValue = (XmlGroupTableValue) XmlGroupValue.updateXmlGroupTableValue(pLot, pOldLot, pCompetenceId, pHasViewRight, lXmlGroupValue, pAction);

            // update details
            lXmlGroupTableValue = XmlGroupTableValue.updateXmlGroupTableDetails(pLot, pOldLot, pCompetenceId, pHasViewRight, lXmlGroupTableValue, pAction);

            // loop on details to clear if needed
            if (lXmlGroupTableValue != null && lXmlGroupTableValue.getGroupTableDetails() != null) {
                for (Iterator<XmlGroupTableDetail> iterator = lXmlGroupTableValue.getGroupTableDetails().iterator(); iterator.hasNext(); ) {
                    XmlGroupTableDetail lXmlGroupTableDetail = iterator.next();

                    //init search
                    boolean lFound = false;

                    // search for value detailed
                    List<String> lCodeToDetail = lXmlGroupTableDetail.getCodesToDetail();
                    if (lCodeToDetail != null) {

                        // is this value the code to detail ?
                        if (lCodeToDetail.contains(lXmlGroupTableValue.getCode())) {
                            lFound = true;
                        } else {
                            // search in other detail values
                            for (Iterator<XmlGroupTableDetail> iterator2 = lXmlGroupTableValue.getGroupTableDetails().iterator(); iterator2.hasNext() && !lFound; ) {
                                XmlGroupTableDetail lTmpDetail = iterator2.next();
                                List<XmlGroupTableDetailValue> lDetailValues = lTmpDetail.findTableDetailValuesByCodes(lCodeToDetail);
                                if (lDetailValues != null && lDetailValues.size() > 0) {
                                    lFound = true;
                                }
                            }
                        }
                    }

                    // found ?
                    if (!lFound) {
                        // the valueto detail is not displayed !
                        iterator.remove();
                    }
                }
            }
        }

        // result
        return lXmlGroupTableValue;
    }

    /**
     * updates the table value group and returns it updated
     *
     * @return
     * @throws SispeaException
     * @throws SispeaException
     */
    public static XmlGroupTableValue updateXmlGroupTableDetails(SPEALotDto pLot, SPEALotDto pOldLot, int pCompetenceId, Boolean pHasViewRight,
                                                                XmlGroupTableValue pXmlGroupTableValue, AbstractSpeaIndicatorsAction pAction) throws SispeaException {

        // init
        XmlGroupTableValue lXmlGroupTableValue = pXmlGroupTableValue;
        List<XmlGroupTableDetail> lDetails = new ArrayList<>();

        if (lXmlGroupTableValue != null) {
            // update details
            for (XmlGroupTableDetail lXmlGroupTableDetail : lXmlGroupTableValue.getGroupTableDetails()) {
                // check detail type
                if (lXmlGroupTableDetail.getType() == null) {
                    throw new SispeaException("Type required for XmlGroupTableDetail");
                } else if (lXmlGroupTableDetail.isDataIndicatorDetail()) {

                    // update values
                    lXmlGroupTableDetail = XmlGroupTableDetail.updateXmlGroupTableInnerValuesDetail(pLot, pOldLot, pCompetenceId, pHasViewRight, lXmlGroupTableDetail, pAction);
                    if (pXmlGroupTableValue != null && lXmlGroupTableDetail != null && !lXmlGroupTableDetail.isEmpty()) {
                        lXmlGroupTableDetail.setId(pAction.getPasswordService().generateNewPassword());
                        lDetails.add(lXmlGroupTableDetail);
                    }

                } else if (lXmlGroupTableDetail.getType() == DataDetailType.Equipment.getId()) {

                    // update values
                    List<XmlGroupTableDetail> lXmlGroupTableDetails = XmlGroupTableDetail.updateXmlGroupTableEquipmentDetail(pLot, pOldLot, pCompetenceId, pHasViewRight, lXmlGroupTableDetail, pAction);
                    if (pXmlGroupTableValue != null && lXmlGroupTableDetails != null && lXmlGroupTableDetails.size() > 0) {

                        // if this value is not editable -> details are not editable
                        if (!lXmlGroupTableValue.isEditable()) {
                            for (XmlGroupTableDetail lDetail : lXmlGroupTableDetails) {
                                lDetail.forceEditable(false);
                            }
                        }

                        // reaplce detail list
                        lDetails.addAll(lXmlGroupTableDetails);
                    }

                } else if (lXmlGroupTableDetail.getType() == DataDetailType.DelegateePriceDetail.getId()
                           || lXmlGroupTableDetail.getType() == DataDetailType.CollectivityPriceDetail.getId()
                           || lXmlGroupTableDetail.getType() == DataDetailType.TaxDetail.getId()) {

                    // update values
                    lXmlGroupTableDetail = XmlGroupTableDetail.updateXmlGroupTablePriceDetail(pLot, pOldLot, pCompetenceId, pHasViewRight, lXmlGroupTableDetail, pAction);
                    if (pXmlGroupTableValue != null && lXmlGroupTableDetail != null && !lXmlGroupTableDetail.isEmpty()) {
                        Collections.sort(lXmlGroupTableDetail.getGroupTableDetailValues());
                        lDetails.add(lXmlGroupTableDetail);
                    }
                }

            }

            // add details ?
            if (lXmlGroupTableValue != null && lDetails != null && lDetails.size() > 0) {
                lXmlGroupTableValue.groupTableDetails = lDetails;
            } else {
                lXmlGroupTableValue.groupTableDetails = null;
            }
        }

        // empty ?
        if (lXmlGroupTableValue != null && lXmlGroupTableValue.isEmpty()) {
            lXmlGroupTableValue = null;
        }

        // result
        return lXmlGroupTableValue;
    }

    /**
     * updates lot with group data
     *
     * @param pXmlGroupTableValue
     * @param pLot
     * @return
     * @throws SispeaException
     */
    public static SPEALotDto updateLotWithGroupData(XmlGroupTableValue pXmlGroupTableValue, SPEALotDto pLot) throws SispeaException, SispeaInputException {

        // init
        SPEALotDto lRes;

        // update current value
        lRes = (SPEALotDto) XmlGroupValue.updateLotWithValue(pXmlGroupTableValue, pLot);

        if (pXmlGroupTableValue.getGroupTableDetails() != null) {

            // update details
            for (XmlGroupTableDetail lXmlGroupTableDetail : pXmlGroupTableValue.getGroupTableDetails()) {
                // check detail type
                if (lXmlGroupTableDetail.getType() == null) {
                    throw new SispeaException("Type required for XmlGroupTableDetail");
                } else if (lXmlGroupTableDetail.isDataIndicatorDetail()) {

                    // update lot
                    lRes = (SPEALotDto) XmlGroupTableDetail.updateLotWithGroupData(lXmlGroupTableDetail, lRes);

                } else if (lXmlGroupTableDetail.getType() == DataDetailType.Equipment.getId()) {

                    // get associated equipment lot
                    EquipmentLotDto lEquipmentLot = lRes.getEquipmentLot(Integer.valueOf(lXmlGroupTableDetail.getCode()));

                    // update lot
                    XmlGroupTableDetail.updateLotWithGroupData(lXmlGroupTableDetail, lEquipmentLot);

                } else if (lXmlGroupTableDetail.getType() == DataDetailType.DelegateePriceDetail.getId()
                           || lXmlGroupTableDetail.getType() == DataDetailType.CollectivityPriceDetail.getId()) {

                    // update lot
                    lRes = (SPEALotDto) XmlGroupTableDetail.updateLotWithPriceGroupData(lXmlGroupTableDetail, lRes);

                } else if (lXmlGroupTableDetail.getType() == DataDetailType.TaxDetail.getId()) {

                    // update lot
                    lRes = (SPEALotDto) XmlGroupTableDetail.updateLotWithGroupData(lXmlGroupTableDetail, lRes);
                }
            }
        }

        // result
        return lRes;

    }

    /**
     * return a table detail (or its clone if indicated) corresponding to id passed. Null if not found
     *
     * @param pXmlGroupTableDetailId
     * @param pXmlGroupTableValue
     * @param pCloneResult           if true result is the clone, else it's the result its self
     * @return
     */
    public static XmlGroupTableDetail findTableDetail(String pXmlGroupTableDetailId, XmlGroupTableValue pXmlGroupTableValue, boolean pCloneResult) {
        // init
        XmlGroupTableDetail lRes = null;


        if (pXmlGroupTableValue.getGroupTableDetails() != null) {
            // search
            for (Iterator<XmlGroupTableDetail> iterator = pXmlGroupTableValue.getGroupTableDetails().iterator(); iterator.hasNext() && lRes == null; ) {
                XmlGroupTableDetail lXmlGroupTableDetail = iterator.next();
                if (lXmlGroupTableDetail != null && lXmlGroupTableDetail.getId() != null && lXmlGroupTableDetail.getId().equals(pXmlGroupTableDetailId)) {
                    // found !
                    lRes = lXmlGroupTableDetail;
                    // clone ?
                    if (pCloneResult) {
                        lRes = lXmlGroupTableDetail.clone();
                    }
                }
            }
        }

        // result
        return lRes;
    }

    public static XmlGroupTableDetail findTableDetail(Integer pDetailTypeId, XmlGroupTableValue pXmlGroupTableValue) {
        // init
        XmlGroupTableDetail lRes = null;


        if (pXmlGroupTableValue.getGroupTableDetails() != null) {
            // search
            for (Iterator<XmlGroupTableDetail> iterator = pXmlGroupTableValue.getGroupTableDetails().iterator(); iterator.hasNext() && lRes == null; ) {
                XmlGroupTableDetail lXmlGroupTableDetail = iterator.next();
                if (lXmlGroupTableDetail != null && lXmlGroupTableDetail.getId() != null && Integer.valueOf(lXmlGroupTableDetail.getType()).equals(pDetailTypeId)) {
                    // found !
                    lRes = lXmlGroupTableDetail;
                }
            }
        }

        // result
        return lRes;
    }

    /**
     * return null or the value corresponding to code if found
     *
     * @param pValues
     * @param pSearchedCodes
     * @return
     */
    public static XmlGroupTableValue findTableValueByCodes(List<XmlGroupTableValue> pValues, String pSearchedCodes) {
        // init
        XmlGroupTableValue lRes = null;

        // get codes
        List<String> lCodes = XmlGroupTableDetail.getCodesListFromString(pSearchedCodes);

        // loop
        for (Iterator<XmlGroupTableValue> iterator = pValues.iterator(); iterator.hasNext() && lRes == null; ) {
            XmlGroupTableValue lXmlGroupTableValue = iterator.next();

            for (Iterator<String> iterator2 = lCodes.iterator(); iterator2.hasNext() && lRes == null; ) {
                String lCode = iterator2.next();

                if (lXmlGroupTableValue.getCode() != null && lXmlGroupTableValue.getCode().equals(lCode)) {
                    lRes = lXmlGroupTableValue;
                }
            }
        }

        // result
        return lRes;
    }

    /**
     * adds a groupTable to groupTablelist
     *
     * @param pGroupTableDetail
     */
    public void add(XmlGroupTableDetail pGroupTableDetail) {
        groupTableDetails.add(pGroupTableDetail);
    }

    @Override
    public boolean isEmpty() {

        // init
        boolean lRes = super.isEmpty();

        // check tables
        if (groupTableDetails != null && groupTableDetails.size() > 0) {
            // table empty ?
            for (Iterator<XmlGroupTableDetail> iterator = groupTableDetails.iterator(); iterator.hasNext() && lRes; ) {
                XmlGroupTableDetail lXmlGroupTableDetail = iterator.next();

                if (lXmlGroupTableDetail.isEmpty()) {
                    lRes = false;
                }
            }
        }

        // result
        return lRes;
    }

    @Override
    public boolean containsIndicator() {

        //init
        boolean lRes = super.containsIndicator();

        // if not indicator, myabe details contains one indicator
        if (!lRes) {
            // check details
            if (groupTableDetails != null && groupTableDetails.size() > 0) {
                // table empty ?
                for (Iterator<XmlGroupTableDetail> iterator = groupTableDetails.iterator(); iterator.hasNext() && !lRes; ) {
                    XmlGroupTableDetail lXmlGroupTableDetail = iterator.next();

                    if (lXmlGroupTableDetail.containsIndicator()) {
                        lRes = true;
                    }
                }
            }
        }
        return lRes;
    }

    /**
     * try to replace both group in tab
     *
     * @param pXmlGroupDetailed
     * @param pXmlGroupToDetail
     */
    public void replaceBoth(XmlGroupTableDetailValue pXmlGroupDetailed, XmlGroupTableDetail pXmlGroupToDetail) {

        if (getGroupTableDetails() != null) {
            // loop on tables
            for (XmlGroupTableDetail lXmlGroupTableDetail : getGroupTableDetails()) {
                // this detail to replace ?
                if (pXmlGroupToDetail.getId().equals(lXmlGroupTableDetail.getId())) {
                    // this detail has to be replaced
                    lXmlGroupTableDetail.copy(pXmlGroupToDetail);
                }

                // continue replacing
                lXmlGroupTableDetail.replace(pXmlGroupDetailed);
            }
        }
    }

    /**
     * return a list of detail values from codes
     *
     * @param pCodes list of string codes
     * @return
     */
    public List<XmlGroupTableDetailValue> findTableDetailValuesByCodes(List<String> pCodes) {
        // init
        List<XmlGroupTableDetailValue> lRes = new ArrayList<>();

        if (getGroupTableDetails() != null) {
            // search for
            for (XmlGroupTableDetail lXmlGroupTableDetail : getGroupTableDetails()) {
                lRes.addAll(lXmlGroupTableDetail.findTableDetailValuesByCodes(pCodes));
            }
        }

        // result
        return lRes;
    }

    /**
     * Returns true if this table contains the data code
     *
     * @param pDatum
     * @return
     */
    public boolean containsData(DataDto pDatum) {

        // init
        boolean lContains;

        // check that this value contrains data
        lContains = super.containsData(pDatum);

        // check on details if needed
        if (groupTableDetails != null) {
            for (Iterator<XmlGroupTableDetail> iterator = groupTableDetails.iterator(); iterator.hasNext() && !lContains; ) {
                XmlGroupTableDetail lDetail = iterator.next();
                lContains = lDetail.containsData(pDatum);
            }
        }

        // result
        return lContains;
    }

    // Getters and setters

    public List<XmlGroupTableDetail> getGroupTableDetails() {
        return groupTableDetails;
    }

    public String getToggleWith() {
        return toggleWith;
    }

    public void setToggleWith(String pToggleWith) {
        toggleWith = pToggleWith;
    }

    public boolean isVisibleIfPublished() {
        if (visibleIfPublished == null) {
            return super.isVisibleIfPublished();
        } else {
            return visibleIfPublished;
        }
    }

    public void setVisibleIfPublished(Boolean pVisibleIfPublished) {
        visibleIfPublished = pVisibleIfPublished;
    }
}
