package fr.onema.sispea.struts.referential.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.SispeaInputException;
import fr.onema.sispea.service.data.DataDetailValueDto;
import fr.onema.sispea.service.data.DataLotDto;


/**
 * This class is a support class to read xml group from a xml file
 *
 * @author CS
 */
public class XmlGroupTableDetailValue extends XmlGroupValue implements Comparable<XmlGroupTableDetailValue> {

    private static final long serialVersionUID = 1L;

    /**
     * force auto compute
     */
    protected Boolean forceAutoCompute = null;

    /**
     * Default constructor.
     */
    public XmlGroupTableDetailValue() {
        super();
    }

    /**
     * copy constructor.
     */
    public XmlGroupTableDetailValue(XmlGroupTableDetailValue pXmlGroup) {
        super(pXmlGroup);
    }

    /**
     * updates lot with group data
     *
     * @param pXmlGroupTableDetailValue
     * @param pLot
     * @return
     * @throws SispeaException
     */
    public static DataLotDto updateLotWithGroupData(XmlGroupTableDetailValue pXmlGroupTableDetailValue, DataLotDto pLot) throws SispeaException, SispeaInputException {

        // init
        DataLotDto lRes;

        // update current value
        lRes = updateLotWithValue(pXmlGroupTableDetailValue, pLot);

        // result
        return lRes;
    }

    /**
     * clone an XmlGroupTableDetailValue Object
     */
    public XmlGroupTableDetailValue clone() {

        // init
        XmlGroupTableDetailValue lRes = new XmlGroupTableDetailValue();

        // copy attributes to the clone
        lRes.copy(this);

        // result
        return lRes;
    }

    /**
     * copy parameter into this
     */
    public void copy(XmlGroupTableDetailValue pXmlGroupTableDetailValue) {
        // copy group attributes
        super.copy(pXmlGroupTableDetailValue);
    }

    /**
     * return true if table is empty, false else
     *
     * @return
     */
    public boolean isEmpty() {

        // init
        boolean lRes = super.isEmpty();

        // result
        return lRes;
    }

    /**
     * return true if table contains indicator
     *
     * @return
     */
    public boolean containsIndicator() {
        return isIndicatorValue();
    }

    /**
     * compare to XmlGroupTableDetailValue
     */
    public int compareTo(XmlGroupTableDetailValue pOther) {

        // init
        final int BEFORE = -1;
        final int EQUAL = 0;
        int lRes = EQUAL;


        // cases
        if (this != pOther) {
            lRes = EQUAL;
        }
        if (pOther == null) {
            lRes = BEFORE;
        } else if (pOther.isSliceValue() && isSliceValue()) {

            // compare upper bounds
            DataDetailValueDto lOtherValue = (DataDetailValueDto) pOther.getValue();
            DataDetailValueDto lThisValue = (DataDetailValueDto) getValue();
            if (lOtherValue != null && lThisValue != null) {
                lRes = lThisValue.getUpperBound().compareTo(lOtherValue.getUpperBound());
            }
        }

        // result
        return lRes;
    }

    public Boolean getForceAutoCompute() {
        return forceAutoCompute;
    }

    public void setForceAutoCompute(Boolean pForceAutoCompute) {
        forceAutoCompute = pForceAutoCompute;
    }
}
