package fr.onema.sispea.struts.referential.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.SispeaInputException;
import fr.onema.sispea.service.data.DataDto;
import fr.onema.sispea.service.data.DataLotDto;
import fr.onema.sispea.service.data.EquipmentLotDto;
import fr.onema.sispea.service.data.SPEALotDto;
import fr.onema.sispea.struts.referential.action.AbstractSpeaIndicatorsAction;
import fr.onema.sispea.util.message.Messages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * This class is a support class to read xml group from a xml file
 *
 * FIXME tchemit-2015-06-25 Do not use action services to build this, use a dedicate object with correct services...
 *
 * @author CS
 */
public class XmlGroupTableDetail extends XmlGroup implements Cloneable {

    private static final long serialVersionUID = 1L;

    /**
     * xml sub group list
     */
    protected List<XmlGroupTableDetailValue> groupTableDetailValues = new ArrayList<>();

    /**
     * The code of table value to detail
     */
    protected String codeToDetail = null;

    /**
     * the group value codes to toggle with
     */
    private String toggleWith = null;

    public XmlGroupTableDetail() {
    }

    /**
     * copy constructor.
     */
    public XmlGroupTableDetail(XmlGroupTableDetail pXmlGroup) {
        super(pXmlGroup);
    }

    /**
     * updates the table value group and returns it updated
     *
     * @return
     * @throws SispeaException
     * @throws SispeaException
     */
    public static XmlGroupTableDetail updateXmlGroupTableInnerValuesDetail(DataLotDto pLot, DataLotDto pOldLot, int pCompetenceId, Boolean pHasViewRight,
                                                                           XmlGroupTableDetail pXmlGroupTableDetail, AbstractSpeaIndicatorsAction pAction) throws SispeaException {

        // init
        XmlGroupTableDetail lXmlGroupTableDetail = pXmlGroupTableDetail;
        List<XmlGroupTableDetailValue> lValues = new ArrayList<>();

        // update tables
        for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : lXmlGroupTableDetail.getGroupTableDetailValues()) {
            // update values
            lXmlGroupTableDetailValue = (XmlGroupTableDetailValue) XmlGroupValue.updateXmlGroupTableValue(pLot, pOldLot, pCompetenceId, pHasViewRight, lXmlGroupTableDetailValue, pAction);
            if (lXmlGroupTableDetail != null && lXmlGroupTableDetailValue != null && !lXmlGroupTableDetailValue.isEmpty()) {

                if (pLot instanceof SPEALotDto) {
                    // HIDE VP : hide vp if service has not the mission
                    Boolean toHide = pAction.getIndicatorService().hideIfNotMission(lXmlGroupTableDetailValue.getCode(),
                                                                                    ((SPEALotDto) pLot).getSpea().getMissionsList());

                    if (!toHide) {
                        Boolean isValid = pAction.getIndicatorService().isInValidityPeriod(lXmlGroupTableDetailValue.getCode(), ((SPEALotDto) pLot).getExercise().getYear());
                        if (isValid == null) {
                            lValues.add(lXmlGroupTableDetailValue);
                        } else if (isValid) {
                            lValues.add(lXmlGroupTableDetailValue);
                        }
                    }
                } else {
                    lValues.add(lXmlGroupTableDetailValue);
                }
            }

            // Dynamic title
            if (lXmlGroupTableDetailValue != null &&
                lXmlGroupTableDetailValue.getCode() != null &&
                lXmlGroupTableDetailValue.getCode().contains("title")) {
                XmlDynamicTitle dynamicTitle = new XmlDynamicTitle(pAction, lXmlGroupTableDetailValue.getCode(), pLot);
                lXmlGroupTableDetailValue.setDynamicTitle(dynamicTitle.getMessage());
            }
        }

        // set list ?
        if (lXmlGroupTableDetail != null) {
            lXmlGroupTableDetail.groupTableDetailValues = lValues;
            if (lXmlGroupTableDetail.getId() == null) {
                lXmlGroupTableDetail.setId(pAction.getPasswordService().generateNewPassword());
            }
        }

        // empty ?
        if (lXmlGroupTableDetail != null && lXmlGroupTableDetail.isEmpty()) {
            lXmlGroupTableDetail = null;
        }

        // result
        return lXmlGroupTableDetail;
    }

    /**
     * updates the table value group and returns it updated
     *
     * @return
     * @throws SispeaException
     * @throws SispeaException
     */
    public static XmlGroupTableDetail updateXmlGroupTablePriceDetail(SPEALotDto pLot, SPEALotDto pOldLot, int pCompetenceId, Boolean pHasViewRight,
                                                                     XmlGroupTableDetail pXmlGroupTableDetail, AbstractSpeaIndicatorsAction pAction) throws SispeaException {

        // init
        XmlGroupTableDetail lXmlGroupTableDetail = pXmlGroupTableDetail;
        List<XmlGroupTableDetailValue> lValues = new ArrayList<>();

        if (pXmlGroupTableDetail != null) {

            // new id
            String lId = pAction.getPasswordService().generateNewPassword();

            // update tables
            for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : lXmlGroupTableDetail.getGroupTableDetailValues()) {
                // update values
                if (lXmlGroupTableDetailValue.isSliceValue() || lXmlGroupTableDetailValue.isPriceValue()) {

                    List<XmlGroupValue> lXmlGroupValues = XmlGroupValue.updateXmlGroupTablePriceValue(pLot, pCompetenceId, pHasViewRight, lXmlGroupTableDetailValue, pAction);
                    if (lXmlGroupTableDetail != null && lXmlGroupValues != null && lXmlGroupValues.size() > 0) {
                        for (XmlGroupValue lXmlGroupValue : lXmlGroupValues) {
                            if (lXmlGroupValue != null && !lXmlGroupValue.isEmpty()) {
                                lXmlGroupValue.setId(pAction.getPasswordService().generateNewPassword());
                                lValues.add((XmlGroupTableDetailValue) lXmlGroupValue);
                            }
                        }
                    }

                } else {
                    lXmlGroupTableDetailValue = (XmlGroupTableDetailValue) XmlGroupValue.updateXmlGroupTableValue(pLot, pOldLot, pCompetenceId, pHasViewRight, lXmlGroupTableDetailValue, pAction);
                    if (lXmlGroupTableDetail != null && lXmlGroupTableDetailValue != null && !lXmlGroupTableDetailValue.isEmpty()) {
                        lXmlGroupTableDetailValue.setId(pAction.getPasswordService().generateNewPassword());
                        lValues.add(lXmlGroupTableDetailValue);
                    }
                }
            }

            lXmlGroupTableDetail.setId(lId);

            // set list ?
            if (lXmlGroupTableDetail != null) {
                lXmlGroupTableDetail.groupTableDetailValues = lValues;
            }
        }

        // result
        return lXmlGroupTableDetail;
    }

    /**
     * updates the table value group and returns it updated
     *
     * @return
     * @throws SispeaException
     * @throws SispeaException
     */
    public static List<XmlGroupTableDetail> updateXmlGroupTableEquipmentDetail(SPEALotDto pLot, SPEALotDto pOldLot, int pCompetenceId, Boolean pHasViewRight,
                                                                               XmlGroupTableDetail pXmlGroupTableDetail, AbstractSpeaIndicatorsAction pAction) throws SispeaException {

        // init
        List<XmlGroupTableDetail> lRes = null;

        if (pXmlGroupTableDetail != null) {

            // result list
            lRes = new ArrayList<>();

            // new id
            String lId = pAction.getPasswordService().generateNewPassword();

            // loop on equipments lots to update groups
            for (EquipmentLotDto lEquipmentLot : pLot.getEquipmentLots()) {
                // retrieve previous exercise equipment
                EquipmentLotDto lOldEquipementLot = null;
                if (pOldLot != null) {
                    lOldEquipementLot = pOldLot.getEquipmentLot(lEquipmentLot.getEquipment().getId());
                }

                // clone group detail
                XmlGroupTableDetail lXmlGroupTableDetail = pXmlGroupTableDetail.clone();

                // update clone
                lXmlGroupTableDetail = XmlGroupTableDetail.updateXmlGroupTableInnerValuesDetail(lEquipmentLot, lOldEquipementLot, pCompetenceId,
                                                                                                pHasViewRight, lXmlGroupTableDetail, pAction);
                // add to result ?
                if (lXmlGroupTableDetail != null && !lXmlGroupTableDetail.isEmpty()) {
                    // update title
                    Messages strutsMessages = pAction.getStrutsMessages();
                    if (lEquipmentLot.getEquipment().getCapacity() != null) {
                        String lTitle = lEquipmentLot.getEquipment().getName() + " - " +
                                        lEquipmentLot.getEquipment().getCapacity() + " " +
                                        strutsMessages.getMessage("fr.onema.sispea.struts.equipments.capacity.unit");

                        if (lEquipmentLot.getEquipment().getSandreCode() != null) {
                            lTitle += " " + strutsMessages.getMessage("fr.onema.sispea.struts.equipments.sandrecode", lEquipmentLot.getEquipment().getSandreCode());
                        }
                        lXmlGroupTableDetail.setTitle(lTitle);
                    } else {
                        if (lEquipmentLot.getEquipment().getSandreCode() != null) {
                            lXmlGroupTableDetail.setTitle(lEquipmentLot.getEquipment().getName() + " " + strutsMessages.getMessage("fr.onema.sispea.struts.equipments.sandrecode", lEquipmentLot.getEquipment().getSandreCode()));
                        } else if (lEquipmentLot.getEquipment().getSiseauCode() != null) {
                            lXmlGroupTableDetail.setTitle(lEquipmentLot.getEquipment().getName() + " " + strutsMessages.getMessage("fr.onema.sispea.struts.equipments.siseaucode", lEquipmentLot.getEquipment().getSiseauCode()));
                        } else {
                            lXmlGroupTableDetail.setTitle(lEquipmentLot.getEquipment().getName());
                        }
                    }
                    lXmlGroupTableDetail.setId(lId);
                    lXmlGroupTableDetail.setCode(lEquipmentLot.getEquipment().getId().toString());

                    // add
                    lRes.add(lXmlGroupTableDetail);
                }
            }
        }

        // empty ?
        if (lRes != null && lRes.size() == 0) {
            lRes = null;
        }

        // result
        return lRes;
    }

    /**
     * updates lot with group data
     *
     * @param pXmlGroupTableDetail
     * @param pLot
     * @return
     * @throws SispeaException
     */
    public static DataLotDto updateLotWithPriceGroupData(XmlGroupTableDetail pXmlGroupTableDetail, DataLotDto pLot) throws SispeaException, SispeaInputException {

        // init
        DataLotDto lRes = pLot;

        // remove slices if needed
        for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : pXmlGroupTableDetail.getGroupTableDetailValues()) {
            if (lXmlGroupTableDetailValue.isSliceValue()) {
                // remove this slices from lot
                SPEALotDto lLot = (SPEALotDto) lRes;

                lLot.removeDataDetailSliceValueByCode(lXmlGroupTableDetailValue.getCode());
            }
        }

        // update lot
        lRes = XmlGroupTableDetail.updateLotWithGroupData(pXmlGroupTableDetail, lRes);

        // result
        return lRes;

    }

    /**
     * updates lot with group data
     *
     * @param pXmlGroupTableDetail
     * @param pLot
     * @return
     * @throws SispeaException
     */
    public static DataLotDto updateLotWithGroupData(XmlGroupTableDetail pXmlGroupTableDetail, DataLotDto pLot) throws SispeaException, SispeaInputException {

        // init
        DataLotDto lRes = pLot;

        for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : pXmlGroupTableDetail.getGroupTableDetailValues()) {
            // update lot
            lRes = XmlGroupTableDetailValue.updateLotWithGroupData(lXmlGroupTableDetailValue, lRes);
        }

        // result
        return lRes;

    }

    public static List<String> getCodesListFromString(String pCodes) {

        // init
        List<String> lRes = new ArrayList<>();

        // split
        if (pCodes != null) {

            String[] lCodes = pCodes.split(",");
            for (String lCode : lCodes) {
                lRes.add(lCode);
            }
        }

        // result
        return lRes;
    }

    /**
     * clone an XmlGroupTableDetail Object
     */
    public XmlGroupTableDetail clone() {

        // init
        XmlGroupTableDetail lRes = new XmlGroupTableDetail();

        // copy attributes to the clone
        lRes.copy(this);

        // result
        return lRes;
    }

    /**
     * copy parameter into this
     */
    public void copy(XmlGroupTableDetail pXmlGroupTableDetail) {

        // copy group attributes
        super.copy(pXmlGroupTableDetail);
        setCodeToDetail(pXmlGroupTableDetail.getCodeToDetail());

        // copy this attributes
        groupTableDetailValues = new ArrayList<>();
        for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : pXmlGroupTableDetail.groupTableDetailValues) {
            groupTableDetailValues.add(lXmlGroupTableDetailValue.clone());
        }
    }

    /**
     * adds a groupTable to groupTablelist
     *
     * @param pGroupTableDetailValue
     */
    public void add(XmlGroupTableDetailValue pGroupTableDetailValue) {
        groupTableDetailValues.add(pGroupTableDetailValue);
    }

    /**
     * return true if table is empty, false else
     *
     * @return
     */
    public boolean isEmpty() {

        // init
        boolean lRes = true;

        // check tables
        if (groupTableDetailValues != null && groupTableDetailValues.size() > 0) {
            // table empty ?
            for (Iterator<XmlGroupTableDetailValue> iterator = groupTableDetailValues.iterator(); iterator.hasNext() && lRes; ) {
                XmlGroupTableDetailValue lXmlGroupTableDetailValue = iterator.next();

                if (!lXmlGroupTableDetailValue.isEmpty()) {
                    lRes = false;
                }
            }
        }

        // result
        return lRes;
    }

    /**
     * return true if detail contains indicator
     *
     * @return
     */
    public boolean containsIndicator() {

        //init
        boolean lRes = false;

        // check details
        if (groupTableDetailValues != null && groupTableDetailValues.size() > 0) {
            // table empty ?
            for (Iterator<XmlGroupTableDetailValue> iterator = groupTableDetailValues.iterator(); iterator.hasNext() && !lRes; ) {
                XmlGroupTableDetailValue lXmlGroupTableDetailValue = iterator.next();

                if (lXmlGroupTableDetailValue.containsIndicator()) {
                    lRes = true;
                }
            }
        }

        return lRes;
    }

    /**
     * try to replace group
     *
     * @param pXmlGroupDetailed
     */
    public void replace(XmlGroupTableDetailValue pXmlGroupDetailed) {

        // loop on tables
        for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : getGroupTableDetailValues()) {
            // this detail to replace ?
            // do not use ids (null) but code
            if (pXmlGroupDetailed.getCode().equals(lXmlGroupTableDetailValue.getCode())) {
                // this detail has to be replaced
                lXmlGroupTableDetailValue.copy(pXmlGroupDetailed);
            }
        }
    }

    /**
     * return a list of detail values from codes
     *
     * @param pCodes list of string codes
     * @return
     */
    public List<XmlGroupTableDetailValue> findTableDetailValuesByCodes(List<String> pCodes) {
        // init
        List<XmlGroupTableDetailValue> lRes = new ArrayList<>();

        // search for
        for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : getGroupTableDetailValues()) {
            if (pCodes.contains(lXmlGroupTableDetailValue.getCode())) {
                lRes.add(lXmlGroupTableDetailValue);
            }
        }

        // result
        return lRes;
    }

    /**
     * force all details values to editable if pEditable is true, to false else
     *
     * @param pEditable value to force on detail values for editable attribute
     */
    public void forceEditable(boolean pEditable) {
        for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : getGroupTableDetailValues()) {
            if (!lXmlGroupTableDetailValue.isAlawaysEditable()) {
                lXmlGroupTableDetailValue.setEditable(pEditable);
            }
        }
    }

    // Getters and setters

    /**
     * Returns true if this table contains the data code
     *
     * @param pDatum
     * @return
     */
    public boolean containsData(DataDto pDatum) {

        // init
        boolean lContains = false;

        // check on details if needed
        if (groupTableDetailValues != null) {
            for (Iterator<XmlGroupTableDetailValue> iterator = groupTableDetailValues.iterator(); iterator.hasNext() && !lContains; ) {
                XmlGroupTableDetailValue lValue = iterator.next();
                lContains = lValue.containsData(pDatum);
            }
        }

        // result
        return lContains;
    }

    public List<XmlGroupTableDetailValue> getGroupTableDetailValues() {
        return groupTableDetailValues;
    }

    public List<String> getCodesToDetail() {

        // init
        List<String> lRes = new ArrayList<>();

        if (isDataIndicatorListDetail()) {
            lRes = getCodesListFromString(codeToDetail);
        } else {
            lRes.add(codeToDetail);
        }

        // result
        return lRes;
    }

    public String getCodeToDetail() {
        return codeToDetail;
    }

    public void setCodeToDetail(String pCodeToDetail) {
        codeToDetail = pCodeToDetail;
    }

    public String getToggleWith() {
        return toggleWith;
    }

    public void setToggleWith(String pToggleWith) {
        toggleWith = pToggleWith;
    }

}
