package fr.onema.sispea.struts.referential.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.ServiceMessages;
import fr.onema.sispea.service.data.DataLotDto;
import fr.onema.sispea.struts.referential.action.AbstractSpeaIndicatorsAction;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/**
 * This class is a support class to read xml dynamic title from a xml file
 * FIXME tchemit-2015-06-25 Do not use action services to build this, use a dedicate object with correct services...
 */
public class XmlDynamicTitle implements Serializable {

    private static final long serialVersionUID = 1L;

    private static final String FORMULA = "formula";

    private static final String VALUESOK = "valuesOk";

    private static final String VALUESNOK = "valuesNok";

    private static final String MESSAGEOK = "messageOk";

    private static final String MESSAGENOK = "messageNok";

    private AbstractSpeaIndicatorsAction action;

    private String message;

    public XmlDynamicTitle(AbstractSpeaIndicatorsAction action, String code, DataLotDto dataLot) {
        this.action = action;
        buildDynamicTitle(code, dataLot);
    }

    /*
     * Read properties for dynamic title in file
     * Build the dynamic title according to the condition formula and the values
     */
    public void buildDynamicTitle(String code, DataLotDto dataLot) {
        // Tokenize the code, example : P103.2B|title1
        List<String> params = new ArrayList<>();
        StringTokenizer tk = new StringTokenizer(code, "|");
        while (tk.hasMoreTokens()) {
            params.add(tk.nextToken());
        }

        // Init the key parent in properties file
        StringBuilder sb = new StringBuilder("fr.onema.sispea.data.value.");
        sb.append(params.get(0) + ".");    // Code
        sb.append(params.get(1) + ".");    // Title

        // Get the condition formula result (true|false) and the values to display in the title
        boolean ok = false;
        ServiceMessages serviceMessages = action.getServiceMessages();
        String formula = serviceMessages.getMessage(sb.toString() + FORMULA);
        List<String> values = new ArrayList<>();
        try {
            // Replace variables
            String replaced = action.getFormCalculateService().replaceVariable(dataLot, formula);

            // Evaluate the formula
            Double result = action.getFormCalculateService().interpret(replaced);
            if (result.equals(Double.NaN)) {
                ok = false;
            } else {
                ok = result.equals(Double.valueOf(1.0));
            }

            String value = (ok) ? serviceMessages.getMessage(sb.toString() + VALUESOK) : serviceMessages.getMessage(sb.toString() + VALUESNOK);
            if (value != null) {
                tk = new StringTokenizer(value, ",");
                while (tk.hasMoreTokens()) {
                    String token = tk.nextToken();
                    String tmp = action.getFormCalculateService().replaceVariable(dataLot, token);
                    if (tmp.equals("\"null\"")) {
                        ok = false;
                        values.add("0");
                    } else {
                        Double d = Double.valueOf(tmp);
                        int i = (int) d.doubleValue();
                        values.add(String.valueOf(i));
                    }
                }
            }
        } catch (SispeaException e) {
            // Do nothing
        }

        // Set the right message
        try {
            if (values != null && values.size() > 0) {
                message = (ok) ? serviceMessages.getMessageWithListArgs(sb.toString() + MESSAGEOK, values) : serviceMessages.getMessageWithListArgs(sb.toString() + MESSAGENOK, values);
            } else {
                message = (ok) ? serviceMessages.getMessage(sb.toString() + MESSAGEOK) : serviceMessages.getMessage(sb.toString() + MESSAGENOK);
            }
        } catch (Exception e) {
            message = "";
        }
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
