package fr.onema.sispea.struts.referential.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


/**
 * This enumeration represents data detail type.
 *
 * @author CS
 */
public enum DataDetailType {
    InnerValuesDetail(0),
    Equipment(1),
    DelegateePriceDetail(2),
    CollectivityPriceDetail(3),
    TaxDetail(4),
    InnerValueListDetail(5);

    /**
     * The resource keys prefix for the enumerated type.
     */
    public static final String PREFIX = "fr.onema.sispea.referential.dataDetailType.";

    /**
     * The data detail type id.
     */
    private int id = -1;

    /**
     * The reliability internationalization Key.
     */
    private String labelKey = null;

    /**
     * Default constructor.
     *
     * @param pId The type ID.
     */
    DataDetailType(int pId) {
        id = pId;
        labelKey = PREFIX + name();
    }

    /**
     * This method parse a string and return a type value.
     *
     * @param pId The string to parse as a type.
     */
    public static DataDetailType parseFromId(int pId) {
        DataDetailType result = null;

        // If we find that one of the enum ID is equal to the given ID, we
        // return the corresponding enum type value.
        for (DataDetailType type : DataDetailType.values()) {
            if (type.getId() == pId) {
                result = type;
                break;
            }
        }

        // If execution goes here, no enum value has been recognized.
        return result;
    }

    public int getId() {
        return id;
    }

    public String getLabelKey() {
        return labelKey;
    }

}
