package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import org.apache.log4j.Logger;

/**
 * This action updates the SPEA link and comment attributes.
 *
 * @author CS
 */
public class UpdateSPEALinkAction extends ShowSPEAPresentationAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateSPEALinkAction.class);

    /**
     * HTTP prefix.
     */
    private static final String URL_PREFIX = "http://";

    @Override
    protected String doExecute() throws Exception {

        String nextPage;

        if (logger.isDebugEnabled()) {
            logger.debug("Updating SPEA link and comment");
        }

        try {
            // Save the link and comment values. They will be overwritten by the showSPEAPresentation load
            String link = spea.getLink();
            String comment = spea.getComment();

            // Load all needed data for the next page: show spea
            nextPage = super.doExecute();

            if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.submit"))) {

                // Reset the new values
                spea.setLink(link);
                spea.setComment(comment);

                // Validate the form input parameters
                nextPage = validateFormParameters();

                if (SUCCESS.equals(nextPage)) {

                    // Update the collectivity
                    referentialService.updateSpea(spea.getId(), link, comment);

                    // Add action message
                    addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.updated"));
                }
            }
        } catch (SispeaException e) {
            nextPage = INPUT;
            edit = true;
            String lMessage = getText(e.getMessage());
            addActionError(getText("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.error.main", "", lMessage));
        }

        return nextPage;
    }

    /**
     * Validates the input parameters.
     *
     * @throws SispeaException
     */
    protected String validateFormParameters() throws SispeaException {

        String nextPage = SUCCESS;

        // Validate the link and comment attributes
        if (spea.getLink() != null) {
            spea.setLink(spea.getLink().trim());
            if ("".equals(spea.getLink())) {
                spea.setLink(null);
            } else {
                if (!spea.getLink().startsWith(URL_PREFIX)) {
                    spea.setLink(URL_PREFIX + spea.getLink());
                }
            }
        }

        if (spea.getComment() != null) {
            spea.setComment(spea.getComment().trim());
            if ("".equals(spea.getComment())) {
                spea.setComment(null);
            } else {
                // Test the length of the comment
                if (spea.getComment().length() > 2000) {
                    edit = true;
                    nextPage = INPUT;
                    addFieldError("spea.comment", getText("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.comment.max.lenght"));
                    addActionError(getText("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.error.validation"));
                }
            }
        }

        return nextPage;
    }

}
