package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.referential.TerritoryPairDto;
import fr.onema.sispea.service.referential.TerritoryType;
import fr.onema.sispea.service.search.SearchTerritoryResultDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * This action display a comparator.
 *
 * @author CS
 */
public class UpdateComparatorAction extends AbstractComparatorAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateComparatorAction.class);

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("update comparator");
        }
        // init result
        String result = SUCCESS;
        // Open menu according to the current JSP item.
        openMenu(MenuConstants.MENU_KEY_COMPARATOR);

        try {

            if (submitValue != null) {
                // add spea id selected
                if (submitValue.equals(getText("fr.onema.sispea.referential.comparator.submit.addSpea"))) {
                    if (speaId != null && !getSispeaSession().getComparatorSpeasIds().contains(speaId) && getSispeaSession().getComparatorSpeasIds().size() < 5) {
                        getSispeaSession().getComparatorSpeasIds().add(speaId);
                    }
                    // print message if  number of selected spea is bigger than 5
                    else if (getSispeaSession().getComparatorSpeasIds().size() == 5) {
                        addActionMessage(getText("fr.onema.sispea.referential.comparator.submit.nbMaxSpea"));
                    }
                }
                // remove spea id selected
                else if (submitValue.equals(getText("fr.onema.sispea.referential.comparator.submit.removeSpea"))) {
                    if (speaId != null && getSispeaSession().getComparatorSpeasIds().contains(speaId)) {
                        getSispeaSession().getComparatorSpeasIds().remove(speaId);
                    }
                }
                // add users SPEAs to his selections
                else if (submitValue.equals(getText("fr.onema.sispea.referential.comparator.submit.addMySpea"))) {
                    // list de spea
                    if ((!getCurrentUser().isCollectivity() && !getCurrentUser().isSpea()) || getCurrentUser().getTerritory() == null) {
                        throw new SispeaException(getText("fr.onema.sispea.referential.comparator.message.forbidAddSpea"));
                    }
                    // Search the territory pairs of the reference territory of the user
                    List<SearchTerritoryResultDto> lSearchResults = territoryService.search(getCurrentUser().getTerritory().getId(), getCurrentUser().getTerritory().getType(),
                                                                                            null, null, TerritoryType.SPEA, null, chosenExerciseId, null, null, false);

                    // Loop on the results
                    for (SearchTerritoryResultDto searchTerritoryResult : lSearchResults) {
                        // Loop on the pairs
                        List<TerritoryPairDto> lPairs = searchTerritoryResult.getPairs();
                        for (TerritoryPairDto territoryPair : lPairs) {
                            TerritoryDto lSpea = territoryPair.getChildTerritory();
                            if (lSpea.getType() == TerritoryType.SPEA) {
                                referentialService.addToUserSelection(getCurrentUser(), lSpea);
                                addActionMessage(getText("fr.onema.sispea.jsp.user.updateUserSelections.singleAdded", "", lSpea.getName()));
                            }
                        }
                    }
                } else if (submitValue.equals(getText("fr.onema.sispea.referential.comparator.field.competence"))) {
                    // We change competence: remove previous SPEAs in session

                }
            }

            // Load the data so the current page can be re-displayed
            loadComparator();


        } catch (SispeaException lEx) {
            logger.error(lEx.getMessage());
            addActionError(lEx.getMessage());
            result = INPUT;
        }

        // result
        return result;
    }
}
