package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.OrganismType;
import fr.onema.sispea.service.referential.SPEADto;
import fr.onema.sispea.service.user.MandateDto;
import org.apache.log4j.Logger;

/**
 * This action updates the mandates for all services of a collectivity.
 *
 * @author CS
 */
public class UpdateCollectivityMandateAction extends ShowCollectivityMandateAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateCollectivityMandateAction.class);

    @Override
    protected String doExecute() throws Exception {

        // log
        if (logger.isDebugEnabled()) {
            logger.debug("Updating mandates for all associated speas");
        }

        // Check input parameters
        validateInputParameters();

        // Load the collectivity
        collectivity = referentialService.readCollectivity(orgId, exercise, false);

        // load territory
        territory = territoryService.readTerritory(collectivity.getId(), OrganismType.Collectivity);

        // Check rights
        canMandate = canMandate(getCurrentUser(), territory);
        if (!canMandate) {
            throw new SispeaException("fr.onema.sispea.jsp.fixRef.showCollectivity.error.unauthorized");
        }

        // Add the mandates
        String currentLogin = getCurrentUser().getLogin();
        int mandatedCount = 0;
        for (String login : usersToMandate) {

            // Add mandates if mandated is not current user
            if (!login.equals(currentLogin)) {

                // Loop through the services of the collectivity
                for (SPEADto spea : collectivity.getSpeas()) {
                    userService.mandate(login, spea.getId(), currentLogin);

                    // Load the set mandate
                    MandateDto mandate = userService.readMandate(login, spea.getId(), currentLogin);

                    // Send a notification
                    userService.notifyUserMandated(getCurrentUser(), mandate, getLocale().getLanguage());
                    mandatedCount++;
                }
            } else {
                // error message
                addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.error.sameLogin"));
            }
        }

        // Add success message
        if (mandatedCount == 0) {
            addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.message.mandateAddedCount0"));
        } else if (mandatedCount == 1) {
            addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.message.mandateAddedCount1"));
        } else {
            addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.message.mandateAddedCountMore", "", String.valueOf(mandatedCount)));
        }

        // Add message sent message
        addActionMessage(getText("fr.onema.sispea.jsp.user.showCollectivity.mandate.sent"));

        // Reload the page
        return super.doExecute();
    }

}
