package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.OrganismType;
import fr.onema.sispea.service.referential.ReferentialService;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.struts.AbstractSispeaAction;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * This action handles the organism visualization.
 *
 * @author CS
 */
public class ShowOrganismAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowOrganismAction.class);

    @Autowired
    protected transient ReferentialService referentialService;

    /**
     * the organism id to display
     */
    protected Integer organismId;

    /**
     * the organism type id to display
     */
    protected Integer organismTypeId;

    /**
     * Id of the territory.
     */
    protected Integer territoryId;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("showOrganismAction do execute");
        }

        try {
            TerritoryDto territoryDto = territoryService.readTerritory(organismId, OrganismType.parseFromDbId(organismTypeId));
            if (territoryDto != null) {
                territoryId = territoryDto.getId();
            }
        } catch (SispeaException lEx) {
            if (logger.isInfoEnabled()) {
                logger.error("Could not find territory for organism: " + organismId, lEx);
            }
        }

        return Action.SUCCESS;

    }

    public Integer getTerritoryId() {
        return territoryId;
    }

    public Integer getOrganismId() {
        return organismId;
    }

    public void setOrganismId(Integer pOrganismId) {
        organismId = pOrganismId;
    }

    public Integer getOrganismTypeId() {
        return organismTypeId;
    }

    public void setOrganismTypeId(Integer pOrganismTypeId) {
        organismTypeId = pOrganismTypeId;
    }

}
