package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.CriterionDto;
import fr.onema.sispea.service.data.CriterionType;
import fr.onema.sispea.service.data.DataDto;
import fr.onema.sispea.service.data.DataType;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.IndicatorDto;
import fr.onema.sispea.service.data.SPEALotDto;
import fr.onema.sispea.service.data.SPEALotService;
import fr.onema.sispea.service.data.SliceDto;
import fr.onema.sispea.service.data.SliceValuesDto;
import fr.onema.sispea.service.data.VPDto;
import fr.onema.sispea.service.referential.SPEADto;
import fr.onema.sispea.service.synthesis.ScatterChartDto;
import fr.onema.sispea.service.synthesis.ScatterChartFactory;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.struts.referential.bean.ComparatorRecapTableBean;
import fr.onema.sispea.struts.referential.bean.ComparatorRecapYear;
import fr.onema.sispea.struts.synthesis.action.AbstractSynthesisAction;
import fr.onema.sispea.util.constants.NumberUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * This action display a data comparator.
 *
 * @author CS
 */
public class ShowDataComparatorAction extends AbstractSynthesisAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowDataComparatorAction.class);

    @Autowired
    protected transient SPEALotService speaLotService;

    /**
     * spea id to display
     */
    protected String speaId;

    /**
     * data id to display
     */
    protected String dataId;

    /**
     * data type to display
     */
    protected String dataTypeId;

    /**
     * the spea to display
     */
    protected SPEADto spea;

    /**
     * PVs list
     */
    protected List<VPDto> pVs;

    /**
     * DCs list
     */
    protected List<DataDto> dCs;

    /**
     * The scatter chart generated by the action.
     */
    protected ScatterChartDto scatterChartComparator;

    /**
     * exercise id to go back to data page
     */
    protected String exerciseId;

    /**
     * editing group id to go back to data page
     */
    protected String editingGroupId;

    /**
     * group id to display when go back to data page
     */
    protected String groupId;

    protected boolean choosenIndicatorVisible;

    protected ComparatorRecapTableBean recapTable = new ComparatorRecapTableBean();

    /**
     * Store the criterion name for each criteria from {@link #criteria} method. Keys are translation key
     */
    protected Map<String, String> criterionNameMap;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("show data comparator");
        }

        // init result
        String lResult = SUCCESS;

        try {
            // Open menu according to the current JSP item.
            openMenu(MenuConstants.MENU_KEY_DATA_COMPARATOR);

            // check spea id
            if (speaId == null) {
                throw new SispeaException("fr.onema.sispea.referential.dataComparator.error.noSpeaId");
            }

            // load spea
            spea = referentialService.readSPEA(Integer.valueOf(speaId), true);
            if (spea == null) {
                throw new SispeaException("fr.onema.sispea.referential.dataComparator.error.wrongSpeaId");
            }

            // set competence
            Integer lDataTypeId = new Integer(dataTypeId);
            competenceId = spea.getCompetence().getId();

            // check parameters
            checkAndGetParameters(false, false);

            if (DataType.getById(lDataTypeId) == DataType.IP) {

                // process IP type indicators
                chosenIndicatorId = Integer.parseInt(dataId);

                // check indicator id
                if (dataId == null) {
                    IndicatorDto lIndic = indicators.iterator().next();
                    dataId = String.valueOf(lIndic.getId());
                    if (dataId != null) {
                        addActionMessage(getText("fr.onema.sispea.referential.dataComparator.message.noDataId"));
                    }
                }
                if (dataId == null) {
                    throw new SispeaException("fr.onema.sispea.referential.dataComparator.error.noDataId");
                }

                // search for data id to display
                IndicatorDto lIndicator = null;
                for (IndicatorDto lInd : indicators) {
                    if (dataId.equals(lInd.getId().toString())) {
                        lIndicator = lInd;
                        break;
                    }
                }

                // found ?
                if (lIndicator == null) {
                    throw new SispeaException("fr.onema.sispea.referential.dataComparator.error.wrongDataId");
                }

                // load data
                Map<Integer, Double> lValues = loadValues(spea, lIndicator);

                // add missing years if needed
                List<ExerciseDto> lExercises = exerciseService.readExercises();
                for (ExerciseDto lExercise : lExercises) {
                    Integer lYear = lExercise.getYear().intValue();
                    if (!lValues.containsKey(lYear)) {
                        lValues.put(lYear, null);
                    }

                }

                // Build graph
                ScatterChartFactory scatterChartFactory = new ScatterChartFactory();
                scatterChartFactory.setServiceMessages(serviceMessages);
                scatterChartComparator = scatterChartFactory.buildDataComparatorChart(spea, lIndicator, lValues);
                if (scatterChartComparator != null) {
                    scatterChartComparator.setSessionChartName(ScatterChartDto.SCATTER_CHART_COMPARATOR);
                }

                // Put the chart into the session so that the JWebChart servlet can access it.
                getSession().put(ScatterChartDto.SCATTER_CHART_COMPARATOR, scatterChartComparator);

                // process Synthesis chart

                // check parameters
                checkAndGetParameters(false, false);

                // criterion set ? and slice set ?
                if (criterion != null) {

                    // find the slice of the criterion for the most recent exercise
                    slice = findCriterionSlice(exercise);

                    if (slice != null) {
                        // do the job
                        processScatterChart(slice, true);

                        // build the recap
                        buildRecap(exercise);
                    }

                }


            } else if (DataType.getById(lDataTypeId) == DataType.VP) {

                // process PV type indicators

                // load data
                pVs = new ArrayList<>();
                checkAndGetVPs();

                // check data id
                if (dataId == null) {
                    dataId = String.valueOf(pVs.get(0).getId());
                    //FIXEM tc20150701 Surprenant ce test ça devrait plutot être dataId == null ?
                    if (dataId != null) {
                        addActionMessage(getText("fr.onema.sispea.referential.dataComparator.message.noDataId"));
                    }
                }
                if (dataId == null) {
                    throw new SispeaException("fr.onema.sispea.referential.dataComparator.error.noDataId");
                }

                // search for data id to display
                VPDto lPV = null;
                for (VPDto lPVNext : pVs) {
                    if (dataId.equals(lPVNext.getId().toString())) {
                        lPV = lPVNext;
                        break;
                    }
                }

                // found ?
                if (lPV == null) {
                    throw new SispeaException("fr.onema.sispea.referential.dataComparator.error.wrongDataId");
                }

                // load data
                Map<Integer, Double> lValues = loadValues(spea, lPV);

                // add missing years if needed
                List<ExerciseDto> lExercises = exerciseService.readExercises();
                for (ExerciseDto lExercise : lExercises) {
                    Integer lYear = lExercise.getYear().intValue();
                    if (!lValues.containsKey(lYear)) {
                        lValues.put(lYear, null);
                    }

                }

                // Build graph
                ScatterChartFactory scatterChartFactory = new ScatterChartFactory();
                scatterChartFactory.setServiceMessages(serviceMessages);
                scatterChartComparator = scatterChartFactory.buildDataComparatorChart(spea, lPV, lValues);
                if (scatterChartComparator != null) {
                    scatterChartComparator.setSessionChartName(ScatterChartDto.SCATTER_CHART_COMPARATOR);
                }

                // Put the chart into the session so that the JWebChart servlet can access it.
                getSession().put(ScatterChartDto.SCATTER_CHART_COMPARATOR, scatterChartComparator);

            } else if (DataType.getById(lDataTypeId) == DataType.DC) {

                // process DC type indicators

                // load data
                dCs = new ArrayList<>();
                checkAndGetCDs();

                // check data id
                if (dataId == null) {
                    dataId = String.valueOf(dCs.get(0).getId());
                    if (dataId != null) {
                        addActionMessage(getText("fr.onema.sispea.referential.dataComparator.message.noDataId"));
                    }
                }
                if (dataId == null) {
                    throw new SispeaException("fr.onema.sispea.referential.dataComparator.error.noDataId");
                }

                // search for data id to display
                DataDto lData = null;
                for (DataDto lCDNext : dCs) {
                    if (dataId.equals(lCDNext.getId().toString())) {
                        lData = lCDNext;
                        break;
                    }
                }

                // found ?
                if (lData == null) {
                    throw new SispeaException("fr.onema.sispea.referential.dataComparator.error.wrongDataId");
                }

                // load data
                Map<Integer, Double> lValues = loadValues(spea, lData);

                // add missing years if needed
                List<ExerciseDto> lExercises = exerciseService.readExercises();
                for (ExerciseDto lExercise : lExercises) {
                    Integer lYear = lExercise.getYear().intValue();
                    if (!lValues.containsKey(lYear)) {
                        lValues.put(lYear, null);
                    }

                }

                // Build graph
                ScatterChartFactory scatterChartFactory = new ScatterChartFactory();
                scatterChartFactory.setServiceMessages(serviceMessages);
                scatterChartComparator = scatterChartFactory.buildDataComparatorChart(spea, lData, lValues);
                if (scatterChartComparator != null) {
                    scatterChartComparator.setSessionChartName(ScatterChartDto.SCATTER_CHART_COMPARATOR);
                }

                // Put the chart into the session so that the JWebChart servlet can access it.
                getSession().put(ScatterChartDto.SCATTER_CHART_COMPARATOR, scatterChartComparator);

            }

            choosenIndicatorVisible = chosenIndicatorId != null && getVisibility(chosenExerciseId, chosenIndicatorId);

            criterionNameMap = buildCriterionNameMap(chosenExerciseId);

        } catch (SispeaException lEx) {
            lResult = Action.INPUT;
            addActionError(getText("fr.onema.sispea.referential.dataComparator.error.common", lEx.getMessage(), getText(lEx.getMessage())));
        }


        // result
        return lResult;
    }

    /**
     * @return values for spea and indicator
     * @throws SispeaException
     */
    protected Map<Integer, Double> loadValues(SPEADto pSpea, IndicatorDto pIndicator) throws SispeaException {

        //fill map to print graph
        Map<Integer, Double> lMap = speaLotService.readSpeaIndicatorValues(pSpea.getId(), pIndicator.getId());

        Map<Integer, Double> lRes = new TreeMap<>();
        ;

        // Remove future exercises
        for (Integer lYear : lMap.keySet()) {

            // get value
            Double lValue = lMap.get(lYear);
            if (lYear <= exerciseService.getCurrentExercise().getYear()) {
                lRes.put(lYear, lValue);
            }
        }

        // result
        return lRes;
    }

    /**
     * @return values for spea and PV
     * @throws SispeaException
     */
    protected Map<Integer, Double> loadValues(SPEADto pSpea, VPDto pPV) throws SispeaException {

        //fill map to print graph
        Map<Integer, Double> lMap = speaLotService.readSpeaPVValues(pSpea.getId(), pPV.getId());

        Map<Integer, Double> lRes = new TreeMap<>();
        ;

        // Remove future exercises
        for (Integer lYear : lMap.keySet()) {

            // get value
            Double lValue = lMap.get(lYear);
            if (lYear <= exerciseService.getCurrentExercise().getYear()) {
                lRes.put(lYear, lValue);
            }
        }

        // result
        return lRes;
    }

    /**
     * @return values for spea and DC
     * @throws SispeaException
     */
    protected Map<Integer, Double> loadValues(SPEADto pSpea, DataDto pData) throws SispeaException {

        //fill map to print graph
        Map<Integer, Double> lMap = speaLotService.readSpeaPVValues(pSpea.getId(), pData.getId());

        Map<Integer, Double> lRes = new TreeMap<>();
        ;

        // Remove future exercises
        for (Integer lYear : lMap.keySet()) {

            // get value
            Double lValue = lMap.get(lYear);
            if (lYear <= exerciseService.getCurrentExercise().getYear()) {
                lRes.put(lYear, lValue);
            }
        }

        // result
        return lRes;
    }

    /**
     * @return Slice
     * @throws SispeaException
     */
    protected SliceDto findCriterionSlice(ExerciseDto pExercise) throws SispeaException {

        // init
        Map<Integer, Double> lValues = null;
        SliceDto lSlice = null;

        // load data
        if (criterion.getType() == CriterionType.IP) {
            lValues = loadValues(spea, criterion.getIndicator());
        } else if (criterion.getType() == CriterionType.VP) {
            lValues = loadValues(spea, criterion.getPv());
        } else if (criterion.getType() == CriterionType.Ponderation && indicator.getReferenceOfCriterion() != null) {
            lValues = loadValues(spea, indicator.getReferenceOfCriterion().getPv());
        }

        // find last year with data
//        Integer lLastYear = 0;

        // For all data selected
        if (lValues != null && lValues.size() > 0) {
//            for (Integer lYear : lValues.keySet()) {
//                if(lYear > lLastYear && lValues.get(lYear) != null) {
//                    lLastYear = lYear;
//                }
//            }
//            Exercise lLastExercise = exerciseService.getExerciseByYear(lLastYear.shortValue());
            ExerciseDto lLastExercise = pExercise;

            if (lLastExercise != null) {
                // year of the slice
                sliceYear = lLastExercise.getYear();
                // Get SpeaLot for current Spea and lLastExercise
                SPEALotDto lSpeaLot = speaLotService.readSpeaLot(lLastExercise.getId(), Integer.parseInt(speaId), Boolean.TRUE);
                // Get the slice associated with the criterion for lLastExercise
                lSlice = sliceService.findSlice(slices, lSpeaLot);
            }
        }

        // result
        return lSlice;
    }

    protected void buildRecap(ExerciseDto pExerciseN) throws SispeaException {

        recapTable = new ComparatorRecapTableBean();

        // init Exercises

        Short lYearN = pExerciseN.getYear();
        Short lYearN_1 = Integer.valueOf(lYearN - 1).shortValue();
        Short lYearN_2 = Integer.valueOf(lYearN - 2).shortValue();

        // compute recap per year
        ComparatorRecapYear lRecapYearN = buildRecapYear(lYearN);
        ComparatorRecapYear lRecapYearN_1 = buildRecapYear(lYearN_1);
        ComparatorRecapYear lRecapYearN_2 = buildRecapYear(lYearN_2);

        // add to the main recap
        recapTable.setYearN(lRecapYearN);
        recapTable.setYearN_1(lRecapYearN_1);
        recapTable.setYearN_2(lRecapYearN_2);

        recapTable.setIndicatorUnit(indicator.getUnit().getSymbol());
        recapTable.setSliceName(slice.getNameSlice());

        // add the criterion unit
        if (criterion.getType() == CriterionType.IP) {
            String lSymbol = criterion.getIndicator().getUnit().getName();
            recapTable.setCriterionUnit(lSymbol);
        } else if (criterion.getType() == CriterionType.VP) {
            String lSymbol = criterion.getPv().getUnit().getName();
            recapTable.setCriterionUnit(lSymbol);
        } else if (criterion.getType() == CriterionType.Ponderation) {
            CriterionDto lCriterion = indicator.getReferenceOfCriterion();
            String lSymbol = lCriterion.getPv().getUnit().getName();
            recapTable.setCriterionUnit(lSymbol);
        }

    }

    /**
     *
     */
    protected ComparatorRecapYear buildRecapYear(Short pYear) throws SispeaException {

        ComparatorRecapYear lRecapYear = new ComparatorRecapYear();

        // init Exercise
        ExerciseDto lExercise = exerciseService.readExercise(pYear);

        if (lExercise != null) {

            // add to the recap
            lRecapYear.setYear(pYear.toString());

            // load indicator values
            Map<Integer, Double> lIndicatorValues;
            Double lIndicatorValue = null;

            lIndicatorValues = loadValues(spea, indicator);
            for (Integer lYear : lIndicatorValues.keySet()) {
                if (pYear.shortValue() == lYear) {
                    lIndicatorValue = lIndicatorValues.get(lYear);
                }
            }

            // add to the recap
            if (lIndicatorValue != null) {
                String lStringValue = NumberUtils.doubleToString(lIndicatorValue, indicator.getDecimal(), false);
                lRecapYear.setIndicatorValue(lStringValue);
            }

            // load slice values for the indicator
            List<SliceValuesDto> lSliceValuesList = indicatorService.getSlicesValues(slices, lExercise.getId());
            SliceValuesDto lSliceValues = findSliceValues(lSliceValuesList, indicator, lExercise, false);
            if (lSliceValues != null) {

                // get avg and nb
                String lSliceAvg = lSliceValues.getFormattedMoy();
                Integer lSliceNb = lSliceValues.getNb();

                // add to the recap
                lRecapYear.setSliceMeanValue(lSliceAvg);
                lRecapYear.setSliceNbValues(lSliceNb.toString());
            }

            // Load all slices
            List<SliceDto> allSlices = indicatorService.findSliceByCompetence(spea.getCompetence().getId(), null);

            // Complete the slice with the criterion
            indicatorService.loadCriteria(allSlices);

            // Get the national average slice
            SliceDto nationalAverageSlice = sliceService.findNationalSlice(allSlices);
            List<SliceDto> slices = new ArrayList<>();
            if (nationalAverageSlice != null) {
                slices.add(nationalAverageSlice);
            }

            List<SliceValuesDto> lNationalSliceValuesList = indicatorService.getSlicesValues(slices, lExercise.getId());

            // load national slice values
            SliceValuesDto lNationalSliceValues = findSliceValues(lNationalSliceValuesList, indicator, lExercise, true);

            if (lNationalSliceValues != null) {

                // get avg and nb
                String lNationalSliceAvg = lNationalSliceValues.getFormattedMoy();
                Integer lNationalSliceNb = lNationalSliceValues.getNb();

                // Get the number of SPEA that can fill in the indicator
                int lSpeaNb = indicatorService.countSpeaLotIndicator(lExercise, spea.getCompetence(), indicator);

                // add to the recap
                lRecapYear.setNationalSliceMeanValue(lNationalSliceAvg);
                lRecapYear.setNationalSliceNbValues(lNationalSliceNb.toString());
                if (lSpeaNb > 0) {
                    int lRatio = Math.round(100 * lNationalSliceNb / lSpeaNb);
                    lRecapYear.setNationalSliceFillRatio(String.valueOf(lRatio));
                }
            }
        }

        return lRecapYear;

    }


    /**
     * This help method returns the <code>SliceValues</code> corresponding to the indicator <code>pIndicator</code>
     * and the exercise <code>pExercise</code>.
     *
     * @param pSliceValues All possible <code>SliceValues</code>.
     * @param pIndicator   The indicator to match.
     * @param pExercise    The exercise to match.
     * @param pAllSpeas    True if the slice to match concerns all SPEAs.
     * @return The found <code>SliceValues</code>
     */
    protected SliceValuesDto findSliceValues(Collection<SliceValuesDto> pSliceValues, IndicatorDto pIndicator, ExerciseDto pExercise, boolean pAllSpeas) {

        SliceValuesDto found = null;
        for (Iterator<SliceValuesDto> iterator = pSliceValues.iterator(); iterator.hasNext() && found == null; ) {
            SliceValuesDto sliceValues = iterator.next();
            if (pExercise.getId() == sliceValues.getIdExercice().intValue()
                && pIndicator.getId().intValue() == sliceValues.getIndicator().getId().intValue()
                && pAllSpeas == sliceValues.getSlice().getAllSpea()) {
                found = sliceValues;
            }
        }

        return found;
    }

    /**
     * load available VPs
     */
    protected void checkAndGetVPs() {

        //
        pVs.clear();

        // find all indicators and get associated PVs
        for (IndicatorDto lIndicator : indicators) {

            Collection<VPDto> lIPVPs = lIndicator.getVpList();
            for (VPDto lPV : lIPVPs) {
                // avoid doubles
                if (!lPV.isDisplayAsDC() && !pVs.contains(lPV)) {
                    // add vp
                    pVs.add(lPV);
                }
            }
        }
    }

    /**
     * load available CDs
     */
    protected void checkAndGetCDs() {

        //
        dCs.clear();

        // find all indicators and get associated CDs
        for (IndicatorDto lIndicator : indicators) {
            Collection<VPDto> lIPVPs = lIndicator.getVpList();
            for (VPDto lPV : lIPVPs) {
                // avoid doubles
                if (lPV.isDisplayAsDC() && !dCs.contains(lPV)) {
                    // add vp
                    dCs.add(lPV);
                }
            }
        }
    }

    public String getSpeaId() {
        return speaId;
    }

    public void setSpeaId(String pSpeaId) {
        speaId = pSpeaId;
    }

    public SPEADto getSpea() {
        return spea;
    }

    public void setSpea(SPEADto pSpea) {
        spea = pSpea;
    }

    public String getDataId() {
        return dataId;
    }

    public void setDataId(String pDataId) {
        dataId = pDataId;
    }

    public String getDataTypeId() {
        return dataTypeId;
    }

    public void setDataTypeId(String pDataTypeId) {
        dataTypeId = pDataTypeId;
    }

    public void setIndicators(List<IndicatorDto> pIndicators) {
        indicators = pIndicators;
    }

    public List<VPDto> getPVs() {
        return pVs;
    }

    public void setPVs(List<VPDto> pPVs) {
        pVs = pPVs;
    }

    public ScatterChartDto getScatterChartComparator() {
        return scatterChartComparator;
    }

    public void setScatterChartComparator(ScatterChartDto pScatterChart) {
        scatterChartComparator = pScatterChart;
    }

    public String getExerciseId() {
        return exerciseId;
    }

    public void setExerciseId(String pExerciseId) {
        exerciseId = pExerciseId;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String pGroupId) {
        groupId = pGroupId;
    }

    public String getEditingGroupId() {
        return editingGroupId;
    }

    public void setEditingGroupId(String pEditingGroupId) {
        editingGroupId = pEditingGroupId;
    }

    public List<DataDto> getDCs() {
        return dCs;
    }

    public void setDCs(List<DataDto> pCs) {
        dCs = pCs;
    }

    public boolean isChoosenIndicatorVisible() {
        return choosenIndicatorVisible;
    }

    public void setChoosenIndicatorVisible(boolean isVisible) {
        this.choosenIndicatorVisible = isVisible;
    }

    public ComparatorRecapTableBean getRecapTable() {
        return recapTable;
    }

    /**
     * @return the criterion name from the translation key
     */
    public String getCriterionName(String pCriterionName) {
        return criterionNameMap.get(pCriterionName);
    }

}
