package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.common.PagingDto;
import fr.onema.sispea.service.search.SearchFieldsDto;
import fr.onema.sispea.service.search.UsersFilterDto;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.service.user.UsersFormDto;
import fr.onema.sispea.struts.SispeaSession;

import java.util.ArrayList;
import java.util.List;

/**
 * This action display a collectivity.<br />
 * The action also loads the search user form to add mandates.
 *
 * @author CS
 */
public class ShowCollectivityMandateAction extends ShowCollectivityAction {

    private static final long serialVersionUID = 1L;

    /**
     * The available users page size
     */
    private static final int AVAILABLE_USER_PAGE_SIZE = 10;

    /**
     * Available users for mandates, used when adding mandates
     */
    protected List<UserDto> availableUsers;

    /**
     * User logins to mandate on all services of the collectivity
     */
    protected List<String> usersToMandate = new ArrayList<>();

    @Override
    protected String doExecute() throws Exception {

        // First load the collectivity data
        String nextPage = super.doExecute();

        // Only load users if the collectivity data has been successfully loaded
        if (SUCCESS.equals(nextPage)) {

            // Load search user data
            // Use session for search
            checkSessionParams();

            // Modify number of user displayed
            searchUsersInfo.getPaging().setPageSize(AVAILABLE_USER_PAGE_SIZE);

            // Search parameters
            SispeaSession sispeaSession = getSispeaSession();
            UsersFormDto usersSearchInfo = sispeaSession.getUsersSearchInfo();
            UsersFilterDto filter = usersSearchInfo.getFilter();
            SearchFieldsDto lFilters = filter.buildQueryFilter(true);

            // Count users if first page
            if (searchUsersInfo.getPaging().getGoToPage() == PagingDto.FIRST_PAGE) {
                int resultCount = userService.countUsers(null, false, lFilters);
                searchUsersInfo.getPaging().setResultCount(resultCount);
            }

            // index to load
            int lStartIndex = searchUsersInfo.getPaging().getStartIndex() * searchUsersInfo.getPaging().getPageSize();
            int lResultSize = searchUsersInfo.getPaging().getPageSize();

            // read users
            availableUsers = userService.readUsers(null, false, lStartIndex, lResultSize, lFilters);

            // Set the new page offset
            searchUsersInfo.getPaging().setPageOffset(searchUsersInfo.getPaging().getStartIndex());

            // Store user paging in session
            sispeaSession.setUsersSearchInfo(searchUsersInfo);

        }

        return nextPage;
    }

    /**
     * @return true if page is mandating
     */
    public boolean isMandating() {
        boolean isMandating = false;
        if (isSearching()) {
            isMandating = true;
        } else if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.addMandatedUser"))) {
            isMandating = true;
        }
        return isMandating;

    }

    /**
     * @return true if searching
     */
    public boolean isSearching() {
        boolean isSearching = false;

        if (searchUsersInfo != null) {
            if (searchUsersInfo.getFilter() != null) {
                if (searchUsersInfo.getFilter().getSubmitValue() != null) {
                    if (searchUsersInfo.getFilter().getSubmitValue().equals(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.available.btnFilter"))) {
                        isSearching = true;
                    }
                }
            }
        }
        return isSearching;
    }

    public List<UserDto> getAvailableUsers() {
        return availableUsers;
    }

    public List<String> getUsersToMandate() {
        return usersToMandate;
    }

    public void setUsersToMandate(List<String> pLogins) {
        usersToMandate = pLogins;
    }
}
