package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.common.PagingDto;
import fr.onema.sispea.service.referential.OrganismType;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.search.SearchFieldsDto;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the SPEA user search.
 * It allows the end user to search for users to mandates.
 *
 * @author CS
 */
public class SearchSPEAPresentationAction extends AbstractSPEAPresentationAction {

    private static final long serialVersionUID = 1L;

    /**
     * the available user's page size
     */
    private static final Integer AVAILABLE_USER_PAGE_SIZE = 10;

    private static final Logger logger = Logger.getLogger(SearchSPEAPresentationAction.class);

    /**
     * can view mandate ?
     */
    protected boolean canViewMandate;

    /**
     * can mandate ?
     */
    protected boolean canMandate;

    /**
     * Territory associated to current organism displayed.
     */
    protected TerritoryDto territory;

    @Override
    protected String doExecute() throws Exception {

        // init result
        String result = SUCCESS;

        // log
        if (logger.isDebugEnabled()) {
            logger.debug("search spea presentation");
        }

//        // set canedit to null
//        setCanEdit(null);

        // menu
        openMenu(MenuConstants.MENU_KEY_PRESENTATION);

        // check params
        initPagingSizes();
        checkExercise();
        checkId();

        // read spea
        spea = referentialService.readSPEA(orgId, exercise, false);

        // check spea
        if (spea == null) {
            throw new SispeaException("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.error.emptySpea");
        }

        // load territory
        territory = territoryService.readTerritory(spea.getId(), OrganismType.SPEA);

        canMandate = checkUserRight(Right.Mandate, territory, exercise);
        canViewMandate = checkUserRight(Right.ViewMandates, territory, exercise);

        // read mandates
        spea.setMandates(userService.readSpeaMandates(spea.getId()));

        // use session for search
        checkSessionParams();

        // modify number of user displayed
        searchUsersInfo.getPaging().setPageSize(AVAILABLE_USER_PAGE_SIZE);

        // search params
        SearchFieldsDto lFilters = getSispeaSession().getUsersSearchInfo().getFilter().buildQueryFilter(true);

        // count users if first page
        if (searchUsersInfo.getPaging().getGoToPage() == PagingDto.FIRST_PAGE) {
            // get count
            int resultCount = userService.countUsers(null, false, lFilters);

            // set to results
            searchUsersInfo.getPaging().setResultCount(resultCount);
        }

        // index to load
        int lStartIndex = searchUsersInfo.getPaging().getStartIndex() * searchUsersInfo.getPaging().getPageSize();
        int lResultSize = searchUsersInfo.getPaging().getPageSize();

        // read users
        availableUsers = userService.readUsers(null, false, lStartIndex, lResultSize, lFilters);

        // page offset
        searchUsersInfo.getPaging().setPageOffset(searchUsersInfo.getPaging().getStartIndex());

        // store in session
        getSispeaSession().setUsersSearchInfo(searchUsersInfo);

        // Load associated users.
        loadUsers(territory);

        // paging
        manageMemberPaging();
        manageEquipmentPaging();
        manageMandatePaging();

        // change menu ?
        openMenu(getProperMenuKey(spea, territory));

        // result
        return result;
    }

    public boolean isCanMandate() {
        return canMandate;
    }

    public void setCanMandate(boolean canMandate) {
        this.canMandate = canMandate;
    }

    public boolean isCanViewMandate() {
        return canViewMandate;
    }

    public void setCanViewMandate(boolean canViewMandate) {
        this.canViewMandate = canViewMandate;
    }

    public TerritoryDto getTerritory() {
        return territory;
    }

}
