package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.data.SpeaComparatorItemDto;
import fr.onema.sispea.service.data.SpeaComparatorItemIdDto;
import fr.onema.sispea.service.exchange.comparator.ComparatorParameters;
import fr.onema.sispea.service.exchange.thread.AsynchronousService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * This action generates the RTF SPEA comparator document.
 *
 * @author CS
 */
public class RtfComparatorAction extends ShowComparatorAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(RtfComparatorAction.class);

    /**
     * The asynchronous service handling the batch generations.
     */
    @Autowired
    @Qualifier("speaComparatorGeneratorService")
    protected transient AsynchronousService batchGenerator;

    @Override
    protected String doExecute() throws Exception {

        String view;

        if (logger.isDebugEnabled()) {
            logger.debug("Generating rtf comparator sheet");
        }

        // Load the data so the current page can be re-displayed
        view = super.doExecute();

        // Prepare the export parameters
        ComparatorParameters parameters = new ComparatorParameters();

        parameters.setUser(getCurrentUser());
        parameters.setExerciseId(exercise.getId());
        parameters.setCompetenceId(competenceId);
        for (SpeaComparatorItemDto speaCompItem : comparatorSpeasLots) {
            parameters.getComparatorIds().add(new SpeaComparatorItemIdDto(speaCompItem));
        }
        if (comparatorType.equals(COMPARATOR_TYPE_ALL)) {
            parameters.setShowVps(true);
        } else if (comparatorType.equals(COMPARATOR_TYPE_IND)) {
            parameters.setShowVps(false);
        }

        // Generate the data model
        if (comparatorSpeasLots.size() > 0) {
            addActionMessage(getText("fr.onema.sispea.referential.comparator.generating"));

            batchGenerator.execute(parameters);
        }

        return view;
    }

}
