package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.OrganismDto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * This action handles the user'selection of a territory to add its associated organism(s) to the
 * currently edited mixed territory.
 *
 * @author CS
 */
public class AddOrganismToTerritoryAction extends AbstractTerritoryAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(AddOrganismToTerritoryAction.class);

    /**
     * The user bean returned by the action.
     */
    protected UserDto user;

    /**
     * IDs of the chosen territories to add to the mixed territory.
     */
    protected List<String> chosenTerritoriesId;

    @Override
    protected String doExecute() throws Exception {

        int lNbAdded = 0;
        String lResult = SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("Selected organism for a mixed territory");
        }

        // Set territory menu
        openMenu(MenuConstants.MENU_KEY_SEE_TERRITORY);

        // check exercise
        checkExercise();

        // check territory to update
        checkTerritory();

        // If there is a new organism to add to the territory :
        // check territory ids selected
        if (chosenTerritoriesId == null || chosenTerritoriesId.size() == 0) {
            throw new SispeaException("fr.onema.sispea.jsp.fixRef.showTerritory.msg.noTerritorySelected");
        }

        for (String lStrTerritoryId : chosenTerritoriesId) {
            // transform to integer
            Integer lTerritoryId;
            try {
                lTerritoryId = Integer.valueOf(lStrTerritoryId);
            } catch (NumberFormatException lEx) {
                throw new SispeaException("fr.onema.sispea.jsp.fixRef.showTerritory.msg.wrongFormatId");
            }

            // Load the organism from the DB.
            TerritoryDto lTerritory = territoryService.readTerritory(lTerritoryId);

            // Reload the parent territory (because paging mechanism truncate the paginated lists: here, the organisms list).
            TerritoryDto lParentTerritory = territoryService.readTerritory(territory.getId());

            // Load associated users.
            loadTerritoryUsers(lParentTerritory);

            // If mixed parent territory exists...
            if (lParentTerritory != null) {

                // Add all organisms from the chosen territory, but avoid doubles.
                for (OrganismDto lOrg : lTerritory.getOrganisms()) {
                    // If organism doesn't already exists into the territory...
                    if (!lParentTerritory.getOrganisms().contains(lOrg)) {
                        // Add it to the territory.
                        lParentTerritory.addOrganism(lOrg);
                        lNbAdded++;
                    } else {
                        // Warn user that this organism hasn't been added because it was already in the territory list.
                        addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showTerritory.msg.organismAlreadyPresent", new String[]{lOrg.getName()}));
                    }
                }

                // Show a message to the user, according to the organism adding case.
                if (lTerritory.getOrganisms().size() == 0) {
                    addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showTerritory.msg.noAssociatedOrganism"));
                } else if (lNbAdded == 0) {
                    addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showTerritory.msg.noNewOrganismAdded"));
                } else {
                    addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showTerritory.msg.addOrganism.success", "", lTerritory.getName()));

                    // Set the updated territory into session.
                    setTerritory(lParentTerritory);

                    // Save territory into the database.
                    referentialService.updateTerritory(lParentTerritory);

                    // Update pagination indexes.
                    manageOrganismPaging();

                    // Territory organisms are no more modified.
                    modifOrganisms = false;
                }
            }
        }

        return lResult;
    }

    public UserDto getUser() {
        return user;
    }

    public void setUser(UserDto pUser) {
        user = pUser;
    }

    public List<String> getChosenTerritoriesId() {
        return chosenTerritoriesId;
    }

    public void setChosenTerritoriesId(List<String> pChosenTerritoriesId) {
        chosenTerritoriesId = pChosenTerritoriesId;
    }

}
