package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.SPEALotService;
import fr.onema.sispea.service.data.SPEALotStatus;
import fr.onema.sispea.service.referential.DDTDto;
import fr.onema.sispea.service.referential.DepartmentDto;
import fr.onema.sispea.service.referential.ReferentialService;
import fr.onema.sispea.service.referential.SPEADto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.service.user.UserDto;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * This action is the base class for all referential cards actions.
 *
 * @author CS
 */
public abstract class AbstractReferentialCardAction extends AbstractExerciseListAction {

    private static final long serialVersionUID = 1L;

    @Autowired
    protected transient ReferentialService referentialService;

    @Autowired
    protected transient SPEALotService speaLotService;

//    /**
//     * territory associated to current organism displayed
//     */
//    protected TerritoryDto territory = null;

    /**
     * id of organism to display as a string
     */
    protected String id;

    /**
     * id of organism to display
     */
    protected Integer orgId;

//    /**
//     * true if current user can view this territory's users
//     */
//    protected boolean canViewUsers;

//    /**
//     * true if current user can view this territory's mandates
//     */
//    protected boolean canViewMandates;

//    /**
//     * true if current user can mandate on this territory
//     */
//    protected boolean canMandate;

//    /**
//     * @return a territory associated to current organism displayed
//     */
//    protected abstract TerritoryDto loadTerritory() throws SispeaException;

    /**
     * check id parameter
     */
    protected void checkId() throws SispeaException {

        // check existence
        if (id == null) {
            throw new SispeaException(getText("fr.onema.sispea.jsp.fixRef.referentialCardAction.error.noId"));
        }

        // check type
        try {
            orgId = Integer.parseInt(id);
        } catch (NumberFormatException lEx) {
            throw new SispeaException(getText("fr.onema.sispea.jsp.fixRef.referentialCardAction.error.wrongType"));
        }

    }

//    /**
//     * @return true if current user can view user list
//     */
//    private Boolean canViewUsers() {
//        // init
//        Boolean lRes = false;
//
//        // check user right
//        UserDto lUser = getCurrentUser();
//        if ((lUser != null)
//            && (lUser.getType().getIncludedTerritoryTypes().contains(getTerritory().getType()))) {
//            try {
//                lRes = checkUserRight(Right.EditUser, getTerritory(), exercise);
//            } catch (SispeaException lEx) {
//                lRes = false;
//            }
//        }
//
//        // result
//        return lRes;
//    }

//    /**
//     * @return true if current user can mandate users on the current territory
//     */
//    protected boolean canMandate(UserDto currentUser, TerritoryDto territory) {
//
//        boolean canMandate = false;
//
//        // check user right
//        if ((currentUser != null) && (currentUser.getType().getIncludedTerritoryTypes().contains(territory.getType()))) {
//            try {
//                canMandate = checkUserRight(Right.Mandate, territory, exercise);
//            } catch (SispeaException lEx) {
//                canMandate = false;
//            }
//        }
//
//        return canMandate;
//    }

    /**
     * @return the ddt corresponding to organism
     */
    protected DDTDto readDdt(Integer pOrganismId, Integer pOrganismTypeId) {

        DDTDto lRes;

        try {
            lRes = referentialService.readDdtFromOrganismId(pOrganismId, pOrganismTypeId, exercise.getId());
        } catch (SispeaException lEx) {
            LOG.error("readDdt failed : " + lEx.getMessage(), lEx);
            lRes = null;
        }

        return lRes;

    }

    /**
     * @return the department corresponding to organism
     */
    protected DepartmentDto readDepartment(Integer pOrganismId, Integer pOrganismTypeId) {

        DepartmentDto lRes;
        try {
            lRes = referentialService.readDepartmentFromOrganismId(pOrganismId, pOrganismTypeId, exercise.getId());
        } catch (SispeaException lEx) {
            LOG.error("readDepartment failed : " + lEx.getMessage(), lEx);
            lRes = null;
        }

        return lRes;

    }

//    /**
//     * @param pSpeaId
//     * @param pExerciseId
//     * @return the status for spea and exercise id
//     * @throws SispeaException
//     */
//    public SPEALotStatus getSpeaLotStatus(Integer pSpeaId, Integer pExerciseId) throws SispeaException {
//        return speaLotService.readSpeaLotStatus(pSpeaId, pExerciseId);
//    }

//    public DataRatioDto getDisplayRatio(Integer pSpeaId, Integer pExerciseId, Boolean pHasViewRight) {
//        return speaLotService.getDisplayRatio(pSpeaId, pExerciseId, pHasViewRight);
//    }

    /**
     * <p>This method checks if the current user is allowed to view the SPEA lot
     * for the exercise pExercise.</p>
     *
     * <p>
     * lot.lotStatus.id == 5 && hasViewRight
     * OR
     * lot.lotStatus.id == 4 && (hasPublishRight || hasCheckRight)
     * OR
     * lot.lotStatus.id != 5 && (hasEditRight || hasCheckRight)
     * </p>
     *
     * @param spea     The requested SPEA.
     * @param exercise The exercise.
     * @return true if the user is allowed to view the SPEA lot, false otherwise.
     * @throws SispeaException If the checkUserRight fails.
     */
    protected boolean hasViewAccess(SPEADto spea, ExerciseDto exercise) throws SispeaException {

        SPEALotStatus speaLotStatus = speaLotService.readSpeaLotStatus(spea.getId(), exercise.getId());

        // Compute the access right
        // Decompose the condition below to not call the checkRight unnecessarily
        //
        //  lot.lotStatus.id == 5 && hasViewRight
        //  OR
        //  lot.lotStatus.id == 4 && (hasPublishRight || hasCheckRight)
        //  OR
        //  lot.lotStatus.id != 5 && (hasEditRight || hasCheckRight)
        boolean hasViewAccess = false;

        if (SPEALotStatus.Published.equals(speaLotStatus)) {
            hasViewAccess = true;
        } else {
            boolean hasCheckRight = checkUserRight(Right.Check, spea, exercise);
            if (hasCheckRight) {
                hasViewAccess = true;
            } else {
                boolean hasEditRight = checkUserRight(Right.Edit, spea, exercise);
                //FIXME tc20150701 No way! A supprimer pas de set pendant un get
//                setCanEdit(hasEditRight);
                if (hasEditRight) {
                    hasViewAccess = true;
                }

                if (SPEALotStatus.Verified.equals(speaLotStatus)) {
                    boolean hasPublishRight = checkUserRight(Right.Publish, spea, exercise);
                    if (hasPublishRight) {
                        hasViewAccess = true;
                    }
                }
            }
        }

        return hasViewAccess;
    }

//    /**
//     * FIXME tc20150701 A supprimer, chaque action qui veut l'utiliser le déclare
//     * This method exists so that subclasses may save the Edit right computed
//     * by the {#link #hasViewAccess} method.
//     *
//     * @param pCanEdit True if the user has view access.
//     */
//    public void setCanEdit(Boolean pCanEdit) {
//        // Do nothing. Subclasses might want to memorize the view access.
//    }

    /**
     * @param territory the territory to test
     * @return the associated Territory id
     */
    protected int getAssociatedTerritoryId(TerritoryDto territory) {

        int lRes = -1;

        if (territory != null) {
            lRes = territory.getId();
        }
        return lRes;

    }

//    /**
//     * @return the territory
//     */
//    public TerritoryDto getTerritory() {
//
//        if (territory == null) {
//            try {
//                territory = loadTerritory();
//            } catch (SispeaException e) {
//                territory = null;
//            }
//        }
//        return territory;
//    }

//    public void setTerritory(TerritoryDto pTerritory) {
//        territory = pTerritory;
//    }

    public String getId() {
        return id;
    }

    public void setId(String pId) {
        id = pId;
    }

//    public boolean isCanViewUsers() {
//        return canViewUsers;
//    }

//    public boolean isCanMandate() {
//        return canMandate;
//    }

//    public Boolean getCanViewUsers() {
//        if (canViewUsers == null) {
//            canViewUsers = canViewUsers();
//        }
//        return canViewUsers;
//    }

//    public Boolean getCanViewMandates() {
//        if (canViewMandates == null) {
//            canViewMandates = canViewMandates(getCurrentUser());
//        }
//        return canViewMandates;
//    }

//    public Boolean getCanMandate() {
//        if (canMandate == null) {
//            canMandate = canViewMandates(getCurrentUser());
//        }
//        return canMandate;
//    }

//    public void setCanViewUsers(boolean canViewUsers) {
//        this.canViewUsers = canViewUsers;
//    }

    /**
     * @return true if current user can view user list
     */
    protected boolean computeCanViewUsers(UserDto currentUser, TerritoryDto territory, ExerciseDto exercise) {

        boolean lRes = false;
        if (currentUser != null
            && currentUser.getType().getIncludedTerritoryTypes().contains(territory.getType())) {
            try {
                lRes = checkUserRight(Right.EditUser, territory, exercise);
            } catch (SispeaException lEx) {
                lRes = false;
            }
        }
        return lRes;

    }
}
