package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.ExerciseService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * This action is the base class for all exercise list actions.
 *
 * @author CS
 */
public abstract class AbstractExerciseListAction extends AbstractUsersManagementAction {

    private static final long serialVersionUID = 1L;

    @Autowired
    protected transient ExerciseService exerciseService;

    /**
     * The loaded exercise.
     */
    protected ExerciseDto exercise;

    /**
     * The chosen exercise Id.
     */
    protected Integer chosenExerciseId;

    /**
     * Map of execice to display in exercise select box.
     */
    protected Map<Integer, String> exerciseList;

    /**
     * @return a map for exercise selection widget
     */
    public Map<Integer, String> getExerciseList() {
        return exerciseList;
    }

    public ExerciseDto getExercise() {
        return exercise;
    }

    public void setExercise(ExerciseDto pExercise) {
        exercise = pExercise;
    }

    public Integer getChosenExerciseId() {
        return chosenExerciseId;
    }

    public void setChosenExerciseId(Integer pChosenExerciseId) {
        chosenExerciseId = pChosenExerciseId;
    }

    /**
     * check parameters and loads exercise if possible
     */
    protected void checkExercise() throws SispeaException {

        // check exercise
        if (chosenExerciseId == null) {
            chosenExerciseId = exerciseService.getCurrentExerciseId();
        }
        exercise = exerciseService.readExercise(chosenExerciseId);
        if (exercise == null) {
            throw new SispeaException(getText("fr.onema.sispea.jsp.fixRef.exerciseListAction.error.wrongExerciseId"));
        }
        loadExerciseList();

    }

    protected void loadExerciseList() throws SispeaException {

        exerciseList = new TreeMap<>();
        List<ExerciseDto> lExercises = exerciseService.readExercises();
        for (ExerciseDto lExercise : lExercises) {
            exerciseList.put(lExercise.getId(), lExercise.getYear().toString());
        }

    }

}
