package fr.onema.sispea.struts.exchange.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the file downloading initialization.
 *
 * @author CS
 */
public class InitFileDownloadAction extends FileDownloadAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(InitFileDownloadAction.class);

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("Downloading file");
        }

        // set the menu
        openMenu(MenuConstants.MENU_KEY_EXTRACTDATA);

        // check rights : only user authenticated
        UserDto lCurrentUser = getCurrentUser();
        //if (! checkUserRight(Right.View)) {
        if (lCurrentUser == null) {
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        // get extraction territory
        if (lCurrentUser.isGeneralAdmin()) {
            // get current territory selection
            setExtractTerritory(null);
        } else {
            setExtractTerritory(lCurrentUser.getTerritory());
        }

        // selected exercise
        if (exerciseId == null) {
            exerciseId = exerciseService.getCurrentExerciseId();
        }

        // user selections : user is connected
        checkUsersSelections();
        checkCompetence();
        loadExcerciseList();

        // initialize territory
        if (selectionId != null) {
            // if user just enhanced his selections -> select the territory he added
            extractTerritoryId = selectionId;
        } else if (userSelection.contains(lCurrentUser.getTerritory()) && extractTerritoryId == null) {
            // if current user territory is in list -> select it
            extractTerritoryId = lCurrentUser.getTerritory().getId();
        }

        // Prepare the list of available downloads.
        // The list depends on the user rights.
        loadAvailableDownloads(lCurrentUser);

        // The data download is the default
        manageDefaultValues();

        // result
        return Action.SUCCESS;
    }

}
