package fr.onema.sispea.struts.exchange.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.exchange.ExportDto;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.io.FileInputStream;

/**
 * This action downloads a prepared export file.
 *
 * @author CS
 */
public class DownloadPreparedExportAction extends FileDownloadAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(DownloadPreparedExportAction.class);

    /**
     * The identifier of the export to download.
     */
    protected Integer exportId;

    @Override
    protected String doExecute() throws Exception {

        String result = SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("Downloading prepared export: id " + exportId + " exercise id " + exerciseId);
        }

        // Open menu according to the current JSP item.
        openMenu(MenuConstants.MENU_KEY_EXTRACTDATA);

        // Test the input parameters
        if (exportId == null) {
            String msg = "No export identifier found. Canceling download";
            logger.error(msg);
            throw new SispeaException(msg);
        }

        // Get the current user
        UserDto currentUser = getCurrentUser();

        // Open the requested blob.
        // An exception will be thrown if the user is not allowed to download
        // the requested export.
        ExportDto export = fileExchangeService.readPreparedExport(currentUser, exportId);

        // Prepare the download
        // Update all file download fields.
        contentDisposition = "attachment; filename=\"" + export.getFilename() + "\"";
        fileSize = export.getFile().length();
        contentType = export.getMimeType();
        fileName = export.getFilename();
        inputStream = new FileInputStream(export.getFile()); // FIXME AThimel 07/07/15 export.getFile() is not deleted after download

        // result
        return result;
    }

    public Integer getExportId() {
        return exportId;
    }

    public void setExportId(Integer pExportId) {
        exportId = pExportId;
    }

}
