package fr.onema.sispea.struts.exchange.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import au.com.bytecode.opencsv.CSVWriter;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.exchange.ExchangeMessageDto;
import fr.onema.sispea.util.file.FileConstants;
import org.apache.log4j.Logger;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Collection;

/**
 * This action allows the user to download the file upload summary as a
 * CSV file.
 *
 * @author CS
 */
public class DownloadFileUploadSummaryAction extends AbstractFileUploadAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(DownloadFileUploadSummaryAction.class);

    /**
     * The file to return.
     */
    protected transient InputStream fileStream;

    /**
     * The mime type of the returned file.
     */
    protected String contentType;

    /**
     * The name of the returned file.
     */
    protected String contentDisposition;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("Downloading the validation summary");
        }

        // The messages must be in the session
        Collection<ExchangeMessageDto> messages = getSispeaSession().getUploadedFileMsgs();
        if (messages == null) {
            throw new SispeaException("There is no messages in the session");
        }
        if (messages.isEmpty()) {
            throw new SispeaException("There is no messages in the session");
        }

        File tmpfile = File.createTempFile(getText("fr.onema.sispea.exchange.upload.file.validation.filename"), FileConstants.CSV_SUFFIX);

        CSVWriter writer = new CSVWriter(new FileWriter(tmpfile), FileConstants.CSV_SEPARATOR);

        // feed in your array (or convert your data to an array)
        // Loop through the validation messages
        for (ExchangeMessageDto messageBean : messages) {
            String message;
            // Test if argument is null.
            if (messageBean.getArgument() == null) {
                message = getText(messageBean.getMessageKey());
            } else {
                message = getText(messageBean.getMessageKey(), "", messageBean.getArgument().toString());
            }

            // Transform the bean to an array
            String[] entries = {messageBean.getCode(),
                                getText(messageBean.getType().getLabelKey()),
                                message};
            writer.writeNext(entries);
        }
        writer.close();

        contentDisposition = "attachment; filename=\"" + tmpfile.getName() + "\"";
        contentType = FileConstants.MIME_CSV;

        // Open input stream on the file
        fileStream = new FileInputStream(tmpfile); // FIXME AThimel 07/07/15 tmpFile is not deleted after download

        return SUCCESS;
    }

    /**
     * Returns a stream to the file.
     */
    public InputStream getFileStream() {
        return fileStream;
    }

    /**
     * Setter for the file stream.
     */
    public void setFileStream(InputStream pFileStream) {
        fileStream = pFileStream;
    }

    public String getContentDisposition() {
        return contentDisposition;
    }

    public String getContentType() {
        return contentType;
    }
}
