package fr.onema.sispea.struts.exchange.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.exchange.ExportParameters;
import fr.onema.sispea.service.exchange.FileType;
import fr.onema.sispea.service.referential.CompetenceDto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * This action download a CSV file.
 *
 * @author CS
 */
public class DownloadAction extends FileDownloadAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(DownloadAction.class);

    /**
     * nb excahnges in queue
     */
    private int queueSize;

    @Override
    protected String doExecute() throws Exception {
        String result = SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("Download file");
        }

        // Open menu according to the current JSP item.
        openMenu(MenuConstants.MENU_KEY_EXTRACTDATA);

        try {

            // check rights : only user authenticated
            UserDto lCurrentUser = getCurrentUser();
            if (lCurrentUser == null) {
                throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
            }

            // First check and validate all input parameters
            // before starting to load data from the database
            //
            // Check extract territory
            if (getExtractTerritoryId() == null) {
                throw new SispeaException("fr.onema.sispea.exchange.download.file.noTerritory");
            }

            // Check and convert the file format
            // The database is not accessed
            String downloadFormat = getDownloadFormat();
            if (downloadFormat == null) {
                throw new SispeaException("fr.onema.sispea.exchange.download.file.missingFileType");
            }
            if (downloadFormat.equals(getText("fr.onema.sispea.exchange.download.file.formatXML"))) {
                setFileType(FileType.XML);
            } else if (downloadFormat.equals(getText("fr.onema.sispea.exchange.download.file.formatCSV"))) {
                setFileType(FileType.CSV);
            } else {
                throw new SispeaException("fr.onema.sispea.exchange.download.file.wrongFileType");
            }

            // Check that at least data or referential is checked
            if (!withData && !withReferential) {
                throw new SispeaException("fr.onema.sispea.exchange.download.file.no.content");
            }

            // territory to extract id
            setExtractTerritory(territoryService.readTerritory(extractTerritoryId));

            // Check extract territory read
            if (getExtractTerritory() == null) {
                throw new SispeaException("fr.onema.sispea.exchange.download.file.wrongTerritory");
            }

            // Get the requested exercise
            if (exerciseId == null) {
                exerciseId = exerciseService.getCurrentExerciseId();
            }
            ExerciseDto lExercise = exerciseService.readExercise(exerciseId);
            if (lExercise == null) {
                throw new SispeaException("fr.onema.sispea.exchange.download.file.wrongExercise");
            }

            // for huge territories, cut it in smaller ones
            List<TerritoryDto> lTerritories = territoryService.buildExtractTerritoryList(extractTerritory, exerciseId, getCurrentUser().getId());

            // check user's right
            UserDto lUser = getCurrentUser();
            //Boolean lHasViewRight = territoryService.hasViewRight(lUser, extractTerritory, lExercise);
            Boolean lHasViewRight = userService.checkUserRight(lUser, Right.View, extractTerritory, lExercise);

            // check that chosen competences are right
            List<CompetenceDto> lCompetences = referentialService.readComptences(chosenCompetences);

            // download params
            ExportParameters lParameters = new ExportParameters(getCurrentUser(),
                                                                lTerritories,
                                                                getLocale().getLanguage(),
                                                                lHasViewRight,
                                                                fileType,
                                                                withData.booleanValue(),
                                                                withReferential.booleanValue(),
                                                                extractTerritory.getName(),
                                                                null,
                                                                getText("fr.onema.sispea.service.exchange.fileName.dateFormat"),
                                                                lExercise,
                                                                lCompetences);

            // download
            queueSize = fileExchangeService.download(lParameters);

            // We update the lastDownloadDate of the current user
            userService.updateLastDownloadDateWithCurrentTime(getCurrentUser());

            // Prepare the list of available downloads.
            // The list depends on the user rights.
            loadAvailableDownloads(lCurrentUser);

            // user selections : user is connected
            checkUsersSelections();
            checkCompetence();

            loadExcerciseList();

        } catch (SispeaException lEx) {
            addActionError(getText(lEx.getMessage()));
            result = Action.INPUT;
        }

        // result
        return result;
    }

    public int getQueueSize() {
        return queueSize;
    }

    public void setQueueSize(int pQueueSize) {
        queueSize = pQueueSize;
    }

}
