package fr.onema.sispea.struts.common.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.ExerciseService;
import fr.onema.sispea.struts.AbstractSispeaAction;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * This action handles the NCS test
 *
 * @author CS
 */
public abstract class AbstractTestNCSAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

//    private static final Logger logger = Logger.getLogger(TestNCSAction.class);

    @Autowired
    protected transient ExerciseService exerciseService;

    /**
     * the name parameter
     */
    protected String name;

    /**
     * The exercise list
     */
    protected List<ExerciseDto> exercises;

    /**
     * The exercise Id chosen
     */
    protected Integer exerciseId;

    /**
     * The chosen exercise
     */
    protected ExerciseDto exercise;

//    /**
//     * Execute method of the action.
//     */
//    protected String doExecute() throws Exception {
//
//        if (logger.isDebugEnabled()) {
//            logger.debug("sand box - doExecute - souldn't be executed");
//        }
//
//        // result
//        return Action.SUCCESS;
//    }

    /**
     * manage exercise list action
     *
     * @throws SispeaException
     */
    protected void manageExercises() throws SispeaException {

        // read exercises
        exercises = exerciseService.readExercises();

        if (exerciseId != null) {
            exercise = exerciseService.readExercise(exerciseId);
        }
    }

    // getters and setters

    public String getName() {
        return name;
    }

    public void setName(String pName) {
        name = pName;
    }

    public List<ExerciseDto> getExercises() {
        return exercises;
    }

    public void setExercises(List<ExerciseDto> pExercises) {
        exercises = pExercises;
    }

    public Map<String, String> getExerciseList() {

        // init
        Map<String, String> lRes = new TreeMap<>();

        // build list
        for (ExerciseDto lExercise : exercises) {
            lRes.put(lExercise.getId().toString(), lExercise.getYear().toString());
        }

        // result
        return lRes;
    }

    public Integer getExerciseId() {
        return exerciseId;
    }

    public void setExerciseId(Integer pExerciseId) {
        exerciseId = pExerciseId;
    }

    public ExerciseDto getExercise() {
        return exercise;
    }

    public void setExercise(ExerciseDto pExercise) {
        exercise = pExercise;
    }

}
