package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.SPEALotService;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class UpdateAdminPublicationAction extends AbstractAdminPublicationAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowExchangeQueueAction.class);

    @Autowired
    protected transient SPEALotService speaLotService;

    @Override
    protected String doExecute() throws Exception {
        // init
        String lResult = Action.SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("show publication action");
        }

        // check rights
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        // open menu
        openMenu(MenuConstants.MENU_KEY_ADMINPUBLICATION);

        // exercise
        checkExercise();

        // check admin publish type
        checkAdminPublishType();

        try {
            if ((submitValue != null) && (submitValue.equals(getText("fr.onema.sispea.jsp.admin.adminPublication.btnCount")))) {
                // Count all the data to be published
                countPotentialPublishes();

            } else if ((submitValue != null) && (submitValue.equals(getText("fr.onema.sispea.jsp.admin.adminPublication.btnPublish")))) {
                // Publish all the data
                if (originType != null && beforeDate != null && result != null && isBeforeDateValid()) {
                    Thread myThread;

                    AdminPublication adminProcessToLaucnh = getAdministratorProcess();
                    AdminThread adminProcess = new AdminThread(adminProcessToLaucnh);
                    myThread = new Thread(adminProcess, "AdminPublication");

                    // Run thread
                    myThread.start();

                    // info
                    addActionMessage(getText("fr.onema.sispea.jsp.admin.adminPublication.message.info.publish"));

                    // reset
                    result = null;
                }
            }

        } catch (SispeaException e) {
            lResult = Action.INPUT;
            addActionError(getText(e.getMessage()));
        }

        // result
        return lResult;
    }

    /**
     * Count the potentential publishes
     */
    protected void countPotentialPublishes() throws SispeaException {

        if (originType != null && beforeDate != null && isBeforeDateValid()) {
            result = speaLotService.countSpeaLotVerifiedByOrigin(publicationType, exercise.getId(), beforeDate, getFormatDateOnly());
        }
    }

    protected boolean isBeforeDateValid() throws SispeaException {

        boolean lRes;

        // Trying to check if the date is valid
        try {
            DateFormat formatter = new SimpleDateFormat(getFormatDateOnly());
            formatter.setLenient(false);
            formatter.parse(beforeDate);
            lRes = true;

        } catch (ParseException e) {
            throw new SispeaException("fr.onema.sispea.jsp.admin.adminPublication.beforeDate.error");
        }

        return lRes;
    }

}
