package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the exchange queue visualization.
 * maitenance action
 *
 * @author CS
 */
public class ShowExchangeQueueAction extends AbstractExchangeQueueAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowExchangeQueueAction.class);

    @Override
    protected String doExecute() throws Exception {

        // init
        String lResult = Action.SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("show exchange queue action");
        }

        // check rights
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        // open menu
        openMenu(MenuConstants.MENU_KEY_EXCHANGESQUEUE);

        try {
            // lire les échanges
            checkExchanges();

        } catch (SispeaException lEx) {
            lResult = Action.INPUT;
            String lMessage = getText("fr.onema.sispea.jsp.admin.exchangeQueue.error.main", "", getText(lEx.getMessage()));
            addActionError(lMessage);
        }

        // result
        return lResult;
    }

}
