package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the Dashboard visualization.
 *
 * @author CS
 */
public class ShowDashboardInitAction extends AbstractDashboardAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowDashboardInitAction.class);

    @Override
    protected String doExecute() throws Exception {

        // init
        String lRes = SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("show Dashboard");
        }

        // open menu
        openMenu(MenuConstants.MENU_KEY_DASHBOARD);

        // check rights
        if (!checkIfUserCanViewDashBoard()) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        try {
            // load exercise
            loadExercises();

            // load competence and indicator
            loadIndicators();

            // load available territories and chosen territory
            loadTerritories();

            // clean session
            getSispeaSession().clearTerritoryIncludedSpeasIds();

        } catch (SispeaException lEx) {
            String lMessage = getText("fr.onema.sispea.jsp.admin.dashboard.message.error", "", lEx.getMessage());
            logger.error(lMessage);
            addActionError(lMessage);
            lRes = INPUT;
        }

        // result
        return lRes;

    }

}
