package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the new exercise management.
 * It allows the end user to confirm exercise change.
 *
 * @author CS
 */
public class ConfirmExerciseAction extends AbstractExercisesAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ConfirmExerciseAction.class);

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("confirm exercises");
        }

        // set the menu
        openMenu(MenuConstants.MENU_KEY_CHANGEEXERCISE);

        // check rights
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        // find next one
        nextExercise = Integer.valueOf(exerciseService.getCurrentExercise().getYear() + 1).toString();

        // result
        return Action.SUCCESS;
    }

}
