package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.common.AdminPublicationType;
import fr.onema.sispea.service.data.SPEALotService;
import fr.onema.sispea.service.notification.MailTools;
import fr.onema.sispea.service.notification.MailType;
import fr.onema.sispea.service.notification.SispeaMail;
import fr.onema.sispea.service.user.IUserService;
import fr.onema.sispea.service.user.UserDto;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class AdminPublication extends Administrator {

    private static final Logger logger = Logger.getLogger(AdminPublication.class);

    @Autowired
    protected SPEALotService speaLotService;

    @Autowired
    protected IUserService userService;

    @Autowired
    protected MailTools mailTools;

    /**
     * Date before which data has been marked as "checked"
     */
    protected String beforeDate;

    /**
     * Date format we get from localised resource
     */
    protected String beforeDateFormat;

    /**
     * Selected type
     */
    protected AdminPublicationType originType;

    /**
     *
     */
    protected String language;

    /**
     *
     */
    protected UserDto currentUser;

    /**
     *
     */
    protected Integer exerciseId;

    @Override
    public void process() throws SispeaException {

        boolean success;
        String errorMsg = null;

        try {

            // publish
            speaLotService.publishSpeaLotVerifiedByOrigin(
                    originType,
                    exerciseId,
                    beforeDate,
                    beforeDateFormat,
                    language,
                    currentUser
            );
            success = true;

        } catch (SispeaException e) {
            logger.error("Error publishig spea lots : " + e.getMessage());
            success = false;
            errorMsg = e.getMessage();
        }

        // Send mail to current user
        informUser(success, errorMsg);
    }

    /**
     * @param pSuccess
     * @param pErrorMsg
     * @throws SispeaException
     */
    private void informUser(boolean pSuccess, String pErrorMsg) throws SispeaException {

        // mailer
        SispeaMail eMail;
        if (pSuccess) {
            eMail = new SispeaMail(MailType.adminPublishSuccessful, currentUser, null, null);
        } else {
            eMail = new SispeaMail(MailType.adminPublishFailed, currentUser, null, null);
        }

        // params
        eMail.setModifier(currentUser);

        // email adresses
        eMail.addToAddress(currentUser.getEmail());
        eMail.setLang(language);

        // email body params
        eMail.addParam("userName", mailTools.getModifiedDescription(currentUser, language));
        if (!pSuccess) {
            eMail.addParam("errorMsg", pErrorMsg);
        }

        // Send mail
        userService.sendMail(eMail, true);
    }

    public String getBeforeDate() {
        return beforeDate;
    }

    public void setBeforeDate(String pBeforeDate) {
        beforeDate = pBeforeDate;
    }

    public AdminPublicationType getOriginType() {
        return originType;
    }

    public void setOriginType(AdminPublicationType pOriginType) {
        originType = pOriginType;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String pLanguage) {
        language = pLanguage;
    }

    public UserDto getCurrentUser() {
        return currentUser;
    }

    public void setCurrentUser(UserDto pCurrentUser) {
        currentUser = pCurrentUser;
    }

    public Integer getExerciseId() {
        return exerciseId;
    }

    public void setExerciseId(Integer pExerciseId) {
        exerciseId = pExerciseId;
    }

    public String getBeforeDateFormat() {
        return beforeDateFormat;
    }

    public void setBeforeDateFormat(String pBeforeDateFormat) {
        beforeDateFormat = pBeforeDateFormat;
    }

}
