package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.ExerciseService;
import fr.onema.sispea.struts.AbstractSispeaAction;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * This action handles the new exercise management.
 * It allows the end user to initiate a new exercise.
 *
 * @author CS
 */
public abstract class AbstractExercisesAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

//    private static final Logger logger = Logger.getLogger(ExercisesAction.class);

    @Autowired
    protected transient ExerciseService exerciseService;

    /**
     * exercise list
     */
    protected List<ExerciseDto> exercises;

    /**
     * next exercise
     */
    protected String nextExercise;

//    @Override
//    protected String doExecute() throws Exception {
//
//        if (logger.isDebugEnabled()) {
//            logger.debug("exercises action : should not be called");
//        }
//
//        // nothing
//
//        return Action.SUCCESS;
//    }

    public List<ExerciseDto> getExercises() {
        return exercises;
    }

    public void setExercises(List<ExerciseDto> pExercises) {
        exercises = pExercises;
    }

    public String getNextExercise() {
        return nextExercise;
    }

    public void setNextExercise(String pNextExercise) {
        nextExercise = pNextExercise;
    }

}
